/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.price;

import cn.pconline.search.common.tools.price.JavaCharStream;
import cn.pconline.search.common.tools.price.ParseException;
import cn.pconline.search.common.tools.price.PriceExtractorConstants;
import cn.pconline.search.common.tools.price.PriceExtractorTokenManager;
import cn.pconline.search.common.tools.price.PriceRange;
import cn.pconline.search.common.tools.price.Token;
import cn.pconline.search.common.util.Cache;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PriceExtractor
implements PriceExtractorConstants {
    private static Cache cache = new Cache(1000);
    private static Logger logger = Logger.getLogger(PriceExtractor.class);
    private PriceRange range = null;
    private StringBuilder tempBuilder = new StringBuilder();
    public PriceExtractorTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[30];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public PriceExtractor(String input) {
        this(new StringReader(input));
    }

    private double productNum(double product, double base) {
        if (base == 0.0) {
            return product;
        }
        return product * base;
    }

    private void setRangeValue(boolean isUpperValue, double value) {
        if (isUpperValue) {
            if (this.range.getUpValue() == null || this.range.getUpValue() >= value) {
                this.range.setUpValue(value);
                return;
            }
        } else if (this.range.getLowValue() == null || this.range.getLowValue() <= value) {
            this.range.setLowValue(value);
            return;
        }
    }

    private void appendTemp(Object value) {
        this.tempBuilder.append(value);
    }

    private String clearTemp() {
        String v = this.tempBuilder.toString();
        if (this.tempBuilder.length() > 0) {
            this.tempBuilder.delete(0, this.tempBuilder.length());
        }
        return v;
    }

    public static final PriceRange getPriceRange(String input) {
        PriceRange range = (PriceRange)cache.get(input);
        if (range != null) {
            return range;
        }
        PriceExtractor extractor = new PriceExtractor(input);
        try {
            range = extractor.extract();
            if (range == null) {
                cache.add(input, new PriceRange());
            } else {
                if (range.getLowValue() != null && range.getUpValue() != null && range.getLowValue() > range.getUpValue()) {
                    Double up = range.getLowValue();
                    range.setLowValue(range.getUpValue());
                    range.setUpValue(up);
                }
                cache.add(input, range);
            }
            return range;
        }
        catch (Exception e) {
            logger.warn((Object)"extract price error", (Throwable)e);
            return null;
        }
    }

    protected double getPriceValue(double parsedPrice) {
        return parsedPrice;
    }

    private final PriceRange extract() throws ParseException {
        boolean sucess = false;
        this.range = new PriceRange();
        block17: while (true) {
            Token t;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block17;
                }
            }
            block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: {
                    this.jj_consume_token(1);
                    this.range.appendOtherQuery(" ");
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 22: {
                                break;
                            }
                            default: {
                                this.jj_la1[1] = this.jj_gen;
                                break block3;
                            }
                        }
                        t = this.jj_consume_token(22);
                        this.range.appendOtherQuery(t);
                    }
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 0: {
                    this.jj_consume_token(0);
                    return this.range;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 22: {
                    sucess = this.getDoubleRange();
                    if (sucess) {
                        this.clearTemp();
                        break;
                    }
                    this.range.appendOtherQuery(this.clearTemp());
                    break;
                }
                case 19: 
                case 20: {
                    sucess = this.getSingleRange();
                    if (sucess) {
                        this.clearTemp();
                        break;
                    }
                    this.range.appendOtherQuery(this.clearTemp());
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (sucess) {
                this.range.appendOtherQuery(" ");
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: {
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        continue block17;
                    }
                }
                t = this.jj_consume_token(22);
                this.range.appendOtherQuery(t);
            }
            break;
        }
        throw new Error("Missing return statement in function");
    }

    private final boolean getSingleRange() throws ParseException {
        boolean isUpper = false;
        double price = 0.0;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                Token t = this.jj_consume_token(19);
                this.appendTemp(t);
                isUpper = false;
                break;
            }
            case 20: {
                Token t = this.jj_consume_token(20);
                this.appendTemp(t);
                isUpper = true;
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        price = this.getTargetPrice(true);
        if (price != 0.0) {
            this.setRangeValue(isUpper, price);
            return true;
        }
        return false;
    }

    private final boolean getDoubleRange() throws ParseException {
        double price;
        block29: {
            price = 0.0;
            price = this.getTargetPrice(false);
            if (price == 0.0) {
                return false;
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block29;
                }
            }
            this.findOther();
            return false;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 21: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.findSpace();
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                    }
                }
                Token t = this.jj_consume_token(21);
                this.appendTemp(t);
                this.setRangeValue(false, price);
                price = this.getTargetPrice(true);
                block12 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: 
                    case 24: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 23: {
                                t = this.jj_consume_token(23);
                                break block12;
                            }
                            case 24: {
                                this.jj_consume_token(24);
                                this.appendTemp(t);
                                break block12;
                            }
                        }
                        this.jj_la1[8] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                    }
                }
                if (price == 0.0) {
                    return false;
                }
                this.setRangeValue(true, price);
                return true;
            }
            case 25: {
                Token t = this.jj_consume_token(25);
                this.appendTemp(t);
                this.setRangeValue(false, price);
                return true;
            }
            case 26: 
            case 27: {
                Token t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: {
                        t = this.jj_consume_token(26);
                        break;
                    }
                    case 27: {
                        t = this.jj_consume_token(27);
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.appendTemp(t);
                this.setRangeValue(true, price);
                return true;
            }
            case 28: 
            case 29: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 28: {
                        Token t = this.jj_consume_token(28);
                        this.appendTemp(t);
                        break;
                    }
                    case 29: {
                        Token t = this.jj_consume_token(29);
                        this.appendTemp(t);
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.setRangeValue(true, price + price * 0.2);
                this.setRangeValue(false, price - price * 0.2);
                return true;
            }
        }
        this.jj_la1[12] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final double getTargetPrice(boolean allowOther) throws ParseException {
        double numValue = 0.0;
        double numBase = 0.0;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.findOther();
                return 0.0;
            }
        }
        this.jj_la1[14] = this.jj_gen;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.findSpace();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: 
            case 3: {
                Token t;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 2: {
                        t = this.jj_consume_token(2);
                        break;
                    }
                    case 3: {
                        t = this.jj_consume_token(3);
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                numValue = Double.parseDouble(t.image);
                this.appendTemp(t);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.findSpace();
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                    }
                }
                block18 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        numBase = this.getNumBase();
                        if (numBase > 0.0) {
                            numValue *= numBase;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 2: {
                                t = this.jj_consume_token(2);
                                if (numBase > 0.0) {
                                    numValue += Double.parseDouble(t.image) / 10.0 * numBase;
                                }
                                this.appendTemp(t);
                                break block18;
                            }
                        }
                        this.jj_la1[17] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.findSpace();
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: {
                        this.getCurrecyUnit();
                        break block6;
                    }
                }
                this.jj_la1[20] = this.jj_gen;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                block45: while (true) {
                    if ((numBase = (double)this.getNumBase()) > 0.0) {
                        numValue = this.productNum(numBase, numValue);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            continue block45;
                        }
                    }
                    break;
                }
                this.jj_la1[21] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.findSpace();
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: {
                        this.getCurrecyUnit();
                        break block6;
                    }
                }
                this.jj_la1[23] = this.jj_gen;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                numValue = this.getChineseNum();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.findSpace();
                        break;
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: {
                        this.getCurrecyUnit();
                        break block6;
                    }
                }
                this.jj_la1[25] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.getPriceValue(numValue);
    }

    private final void findSpace() throws ParseException {
        this.jj_consume_token(1);
        this.appendTemp(" ");
    }

    private final void findOther() throws ParseException {
        Token t = this.jj_consume_token(22);
        this.appendTemp(t);
    }

    private final void getCurrecyUnit() throws ParseException {
        Token t = this.jj_consume_token(9);
        this.appendTemp(t);
    }

    private final int getNumBase() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                Token t = this.jj_consume_token(5);
                this.appendTemp(t);
                return 10000;
            }
            case 6: {
                Token t = this.jj_consume_token(6);
                this.appendTemp(t);
                return 1000;
            }
            case 7: {
                Token t = this.jj_consume_token(7);
                this.appendTemp(t);
                return 100;
            }
            case 8: {
                Token t = this.jj_consume_token(8);
                this.appendTemp(t);
                return 10;
            }
        }
        this.jj_la1[27] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final double getChineseNum() throws ParseException {
        double baseNum;
        double num;
        block14: {
            Token t;
            num = 0.0;
            baseNum = 0.0;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    t = this.jj_consume_token(10);
                    break;
                }
                case 11: {
                    t = this.jj_consume_token(11);
                    num = this.productNum(2.0, num);
                    break;
                }
                case 12: {
                    t = this.jj_consume_token(12);
                    num = this.productNum(3.0, num);
                    break;
                }
                case 13: {
                    t = this.jj_consume_token(13);
                    num = this.productNum(4.0, num);
                    break;
                }
                case 14: {
                    t = this.jj_consume_token(14);
                    num = this.productNum(5.0, num);
                    break;
                }
                case 15: {
                    t = this.jj_consume_token(15);
                    num = this.productNum(6.0, num);
                    break;
                }
                case 16: {
                    t = this.jj_consume_token(16);
                    num = this.productNum(7.0, num);
                    break;
                }
                case 17: {
                    t = this.jj_consume_token(17);
                    num = this.productNum(8.0, num);
                    break;
                }
                case 18: {
                    t = this.jj_consume_token(18);
                    num = this.productNum(9.0, num);
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.appendTemp(t);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    break block14;
                }
            }
            this.findOther();
            return 0.0;
        }
        baseNum = this.getNumBase();
        num = this.productNum(baseNum, num);
        return num;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{6290927, 0x400000, 2, 6290927, 0x400000, 0x180000, 0x400000, 2, 0x1800000, 0x1800000, 0xC000000, 0x30000000, 1042284546, 2, 0x400000, 12, 2, 4, 480, 2, 512, 480, 2, 512, 2, 512, 523756, 480, 523264, 0x400000};
    }

    public PriceExtractor(InputStream stream) {
        this(stream, null);
    }

    public PriceExtractor(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new PriceExtractorTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public PriceExtractor(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new PriceExtractorTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public PriceExtractor(PriceExtractorTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(PriceExtractorTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[30];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 30; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 30; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        PriceExtractor.jj_la1_init_0();
    }
}

