/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.query;

import cn.pconline.search.common.query.Operator;
import cn.pconline.search.common.query.Q;
import cn.pconline.search.common.util.QueryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class Condition
implements Iterable<Condition> {
    private String field;
    private Object[] value;
    private Operator operator = Operator.SHOULD;
    private List<Condition> childs;
    private Float boost;
    private int slop;
    private boolean isPhraseQuery;

    public Condition() {
    }

    public Condition(Operator operator) {
        this.operator = operator;
    }

    public Condition(String field, Operator operator, Object ... value) {
        this.field = field;
        this.value = value;
        this.operator = operator;
    }

    public Condition(String field, Operator operator, Float boost, Object ... value) {
        this.field = field;
        this.value = value;
        this.operator = operator;
        this.boost = boost;
    }

    public Condition(String field, Object ... value) {
        this.field = field;
        this.value = value;
    }

    public Condition(String field, Float boost, Object ... value) {
        this.field = field;
        this.value = value;
        this.boost = boost;
    }

    public void addChild(Condition c) {
        if (this.childs == null) {
            this.childs = new ArrayList<Condition>();
        }
        this.childs.add(c);
    }

    @Override
    public Iterator<Condition> iterator() {
        if (this.childs == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.childs.iterator();
    }

    public boolean hasChild() {
        return CollectionUtils.isNotEmpty(this.childs);
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setValue(String ... value) {
        this.value = value;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        if (operator == null) {
            return;
        }
        this.operator = operator;
    }

    public Float getBoost() {
        return this.boost;
    }

    public void setBoost(Float boost) {
        this.boost = boost;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.operator.toConnectString()).append(" ");
        if (this.hasChild()) {
            int idx = 0;
            sb.append("(");
            String temp = null;
            for (Condition c : this) {
                temp = c.toString();
                if (idx == 0) {
                    temp = (Object)((Object)c.getOperator()) + temp.substring(c.getOperator().toConnectString().length());
                }
                sb.append(temp).append(" ");
                ++idx;
            }
            sb.append(")");
        } else if (this.value != null && this.value.length > 0) {
            sb.append(this.field);
            sb.append(":");
            sb.append("(");
            for (Object obj : this.value) {
                if (this.isPhraseQuery) {
                    sb.append("\"").append(QueryUtil.escapeQStr(obj.toString())).append("\"");
                    if (this.slop > 0) {
                        sb.append("~").append(this.slop);
                    }
                } else {
                    sb.append(QueryUtil.escapeQStr(obj.toString()));
                }
                sb.append(" ");
            }
            sb.append(")");
        }
        if (this.boost != null && this.boost.floatValue() >= 0.0f && this.boost.floatValue() != 1.0f) {
            sb.append("^");
            sb.append(Condition.formatFloat(this.boost.floatValue()));
        }
        return sb.toString();
    }

    private static String formatFloat(float f) {
        String s = String.valueOf(f);
        int i = 0;
        i = s.indexOf(69);
        if (i > 0) {
            StringBuilder sb = new StringBuilder();
            boolean negative = s.charAt(i + 1) == '-';
            int eCount = Integer.parseInt(s.substring(negative ? i + 2 : i + 1));
            String base = s.substring(0, i);
            if (negative) {
                sb.append("0.");
                int count = 0;
                int last = eCount;
                if (base.indexOf(46) >= 0) {
                    count = eCount - base.indexOf(46);
                    last = Integer.parseInt(base.substring(base.indexOf(46) + 1));
                    base = base.substring(0, base.indexOf(46));
                }
                for (int j = 0; j < count; ++j) {
                    sb.append("0");
                }
                sb.append(base);
                if (last > 0) {
                    sb.append(last);
                }
            } else {
                int count = eCount;
                if (base.indexOf(46) >= 0) {
                    count = eCount - (base.length() - base.indexOf(46) - 1);
                    sb.append(base.substring(0, base.indexOf(46)));
                    sb.append(base.substring(base.indexOf(46) + 1));
                }
                for (int j = 0; j < count; ++j) {
                    sb.append("0");
                }
                sb.append(".0");
            }
            return sb.toString();
        }
        return s;
    }

    public static void main(String[] args) {
        Q q = new Q();
        Condition c = new Condition("status", Operator.MUST, "AND", "AND", "AND", "AND");
        c.setBoost(Float.valueOf(2.0E8f));
        q.addCondition(c);
        System.out.println(q);
    }

    public int getSlop() {
        return this.slop;
    }

    public Condition setSlop(int slop) {
        this.slop = slop;
        return this;
    }

    public boolean isPhraseQuery() {
        return this.isPhraseQuery;
    }

    public Condition setPhraseQuery(boolean isPhraseQuery) {
        this.isPhraseQuery = isPhraseQuery;
        return this;
    }
}

