/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.homonym;

import cn.pconline.search.common.util.CNToSpell;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Homonyms {
    private static Logger logger = Logger.getLogger(Homonyms.class);
    private Map<String, String> dataMap = null;
    private Set<String> set = null;

    public Homonyms(String fileNamesStr) {
        this.init(fileNamesStr);
    }

    public String getHomonyms(String str) {
        if (this.dataMap == null) {
            return null;
        }
        String ret = this.dataMap.get(CNToSpell.getFullSpell(str));
        return ret == null ? "" : ret;
    }

    public static boolean isDomain(String src) {
        String regx = "([\\w-]+\\.)+[\\w-]+(/[\\w-\\.?%=]*)*";
        return src.matches(regx);
    }

    private void init(String fileNamesStr) {
        this.dataMap = new HashMap<String, String>();
        this.set = new HashSet<String>();
        if (fileNamesStr != null) {
            String[] fileNames = fileNamesStr.split(";");
            for (int i = 0; i < fileNames.length; ++i) {
                this.loadFromFile(fileNames[i]);
            }
        }
        this.set = null;
    }

    private void loadFromFile(String fileName) {
        BufferedReader reader = null;
        try {
            logger.debug((Object)("load homonyms file [" + fileName + "] from current classpath"));
            InputStream in = Homonyms.class.getClassLoader().getResourceAsStream(fileName);
            reader = new BufferedReader(new InputStreamReader(in, "gbk"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (this.set.contains(line)) continue;
                this.set.add(line);
                String spell = CNToSpell.getFullSpell(line);
                String str = this.dataMap.get(spell);
                str = str != null ? str + ";" + line : line;
                this.dataMap.put(spell, str);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6\u6587\u4ef6" + fileName + "\u53d1\u751f\u5f02\u5e38\uff01", e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {}
        }
    }
}

