/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.segment;

import cn.pconline.search.common.tools.segment.SegGraph;
import cn.pconline.search.common.tools.segment.bean.Queue;
import cn.pconline.search.common.tools.segment.bean.QueueNode;
import cn.pconline.search.common.tools.segment.bean.SegNode;
import java.util.ArrayList;

public class NShortPath {
    private int pathCount;
    private SegGraph biSegGraph;
    private double[][] pathWeight;
    private Queue[] parent;
    private int vertex;

    public NShortPath(SegGraph bsg, int pathCount) {
        this.biSegGraph = bsg;
        this.pathCount = pathCount;
        if (bsg != null && bsg.getSize() > 0 && pathCount > 0) {
            int i;
            this.vertex = bsg.getMaxCol() + 1;
            if (bsg.getMaxRow() + 1 > this.vertex) {
                this.vertex = bsg.getMaxRow() + 1;
            }
            this.parent = new Queue[this.vertex];
            this.pathWeight = new double[this.vertex][pathCount];
            for (i = 0; i < this.pathWeight.length; ++i) {
                for (int j = 0; j < this.pathWeight[i].length; ++j) {
                    this.pathWeight[i][j] = 10000.0;
                }
            }
            for (i = 0; i < this.vertex; ++i) {
                this.parent[i] = new Queue();
            }
        }
    }

    private void shortPath() {
        int preNode = -1;
        double weight = 0.0;
        if (this.biSegGraph != null) {
            for (int cur = 1; cur < this.vertex; ++cur) {
                ArrayList<SegNode> colSgs = this.biSegGraph.getNodes(cur, true);
                if (colSgs == null || colSgs.size() == 0) {
                    return;
                }
                Queue queWork = new Queue();
                for (SegNode seg : colSgs) {
                    preNode = seg.getRow();
                    weight = seg.getValue();
                    if (preNode == 0) {
                        queWork.push(new QueueNode(preNode, 0, weight));
                        continue;
                    }
                    if (this.pathWeight[preNode][0] == 10000.0) continue;
                    queWork.push(new QueueNode(preNode, 0, weight + this.pathWeight[preNode][0]));
                }
                QueueNode minNode = null;
                for (int pathIndex = 0; (minNode = queWork.pop()) != null && pathIndex < this.pathCount; ++pathIndex) {
                    this.pathWeight[cur][pathIndex] = minNode.getWeight();
                    this.parent[cur].push(minNode);
                }
            }
        }
    }

    public ArrayList<ArrayList<Integer>> getPaths() {
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        ArrayList<Integer> onePath = null;
        Queue queResult = null;
        int curIndex = 0;
        int pathIndex = 0;
        this.shortPath();
        if (this.vertex > 0) {
            queResult = new Queue();
            queResult.push(new QueueNode(this.vertex - 1, 0, 0.0));
            int curNode = this.vertex - 1;
            curIndex = 0;
            block0: while (!queResult.isEmpty()) {
                QueueNode qn;
                while (curNode > 0) {
                    qn = this.parent[curNode].pop(false);
                    if (qn == null) {
                        qn = this.parent[curNode].top();
                    }
                    if (qn != null) {
                        curNode = qn.getParent();
                        curIndex = qn.getIndex();
                    }
                    if (curNode <= 0) continue;
                    queResult.push(new QueueNode(curNode, curIndex, 0.0));
                }
                if (curNode != 0) continue;
                qn = null;
                onePath = new ArrayList<Integer>();
                onePath.add(curNode);
                while ((qn = queResult.pop(false)) != null) {
                    onePath.add(qn.getParent());
                }
                result.add(onePath);
                queResult.resetIndex();
                if (++pathIndex == this.pathCount) break;
                while ((qn = queResult.pop()) != null) {
                    curNode = qn.getParent();
                    QueueNode next = this.parent[curNode].pop(false);
                    if (next == null) continue;
                    curNode = next.getParent();
                    next.setWeight(0.0);
                    queResult.push(qn);
                    queResult.push(next);
                    continue block0;
                }
            }
        }
        return result;
    }

    public int[] getPaths(int index) {
        int[] rs = null;
        ArrayList<ArrayList<Integer>> result = this.getPaths();
        if (result != null && index < result.size()) {
            rs = new int[result.get(index).size()];
            int i = 0;
            for (int p : result.get(index)) {
                rs[i++] = p;
            }
        }
        return rs;
    }

    public void printPath(ArrayList<ArrayList<Integer>> paths) {
        if (paths != null) {
            for (int i = 0; i < paths.size(); ++i) {
                String result = "path[" + i + "]:";
                for (int j : paths.get(i)) {
                    result = result + j + ",";
                }
            }
        }
    }

    public int getPathCount() {
        return this.pathCount;
    }

    public void setPathCount(int pathCount) {
        this.pathCount = pathCount;
    }
}

