/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.sensitive;

import cn.pconline.search.common.Configuration;
import cn.pconline.search.common.tools.sensitive.OracleSensitiveWordSource;
import cn.pconline.search.common.tools.sensitive.SensitiveFilter;
import cn.pconline.search.common.tools.sensitive.SensitiveMatcher;
import cn.pconline.search.common.tools.sensitive.SensitiveMatcherImpl;
import cn.pconline.search.common.tools.sensitive.SensitiveWord;
import cn.pconline.search.common.tools.sensitive.SensitiveWordSource;
import cn.pconline.search.common.util.DailyFixTimeRunThread;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AnalyzeSensitiveFilter
extends DailyFixTimeRunThread
implements SensitiveFilter {
    private static final Logger logger = Logger.getLogger(AnalyzeSensitiveFilter.class);
    private ReentrantLock loadLock = new ReentrantLock();
    private String wordDb;
    protected volatile WordMapping mapping = null;
    private String domain;

    public AnalyzeSensitiveFilter(Configuration config) {
        super(config.getConfig("sensitiveWordReloadTime", ""), "SensitiveWord-Load-Thread");
        this.wordDb = config.getConfigNotEmpty("sensitiveWordDb");
        this.domain = config.getConfig("sensitiveFilterDomain", "pconline");
        this.doLoad();
        this.start();
    }

    @Override
    protected void doRun() {
        this.doLoad();
    }

    @Override
    public SensitiveMatcher matchSensitive(String input) {
        return this.hasSensitiveInMapping(input, this.mapping);
    }

    private SensitiveMatcher hasSensitiveInMapping(String input, WordMapping mapping) {
        if (StringUtils.isBlank((String)input)) {
            return SensitiveMatcher.EMPTY_MATCHER;
        }
        if ((input = input.trim()).length() < mapping.getMinWordLen()) {
            return SensitiveMatcher.EMPTY_MATCHER;
        }
        if (!mapping.hasMapping()) {
            return SensitiveMatcher.EMPTY_MATCHER;
        }
        return new SensitiveMatcherImpl(mapping, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload(SensitiveWordSource source) {
        this.loadLock.lock();
        try {
            int total = 0;
            WordMapping mapping = new WordMapping();
            SensitiveWord word = null;
            while ((word = source.nextWord()) != null) {
                mapping.addWord(word);
                this.mapping = mapping;
                ++total;
            }
            logger.info((Object)("Load SensitiveFilter with [" + total + "] words"));
        }
        finally {
            this.loadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoad() {
        OracleSensitiveWordSource source = null;
        try {
            this.loadLock.lock();
            source = new OracleSensitiveWordSource(this.wordDb, this.domain);
            this.reload(source);
        }
        finally {
            this.loadLock.unlock();
            if (source != null) {
                source.close();
            }
        }
    }

    static class WordMapping {
        private int minWordLen = Integer.MAX_VALUE;
        private int maxWordLen = 0;
        private Map<String, SensitiveWord> wordMap = new HashMap<String, SensitiveWord>();

        WordMapping() {
        }

        public void addWord(SensitiveWord word) {
            this.wordMap.put(word.getWord(), word);
            this.minWordLen = Math.min(word.getWord().length(), this.minWordLen);
            this.maxWordLen = Math.max(word.getWord().length(), this.maxWordLen);
        }

        public SensitiveWord hasWord(String word) {
            return this.wordMap.get(word);
        }

        public int getMaxWordLen() {
            return this.maxWordLen;
        }

        public boolean hasMapping() {
            return MapUtils.isNotEmpty(this.wordMap);
        }

        public int getMinWordLen() {
            return this.minWordLen;
        }
    }
}

