package cn.pconline.search.common.taglib;

import javax.servlet.jsp.JspException;

/**
 * 通用分页标签
 * 
 * @author zengjie
 * @since 2013-9-17
 * @see
 */
public class CommonPagerTag extends BaseTag
{

    private static final long serialVersionUID = -6421737674756807494L;

    private Integer totalCount;

    private Integer perPage;

    private String currentPageUrl;

    private Integer currentPageNo;

    /**
     * 上一页按钮样式
     */
    private String prevClass = "prev";

    /**
     * 下一页按钮样式
     */
    private String nextClass = "next";

    @Override
    public int doStartTag() throws JspException
    {
        int pageCount = (totalCount - 1) / perPage;
        if (pageCount > 0)
        {
            String aUrl = currentPageUrl;
            if (currentPageNo > 0)
            {
                HtmlTag pre = new HtmlTag("a", new HtmlText("上一页"));
                pre.addAttribute("href", aUrl + "&pageNo=" + currentPageNo);
                pre.addAttribute("target", "_self");
                pre.addAttribute("class", prevClass);
                writeToOut(pre);
                HtmlTag first = new HtmlTag("a", new HtmlText(1));
                first.addAttribute("target", "_self");
                first.addAttribute("href", aUrl);
                writeToOut(first);
            }
            else
            {
                writeToOut(new HtmlTag("span", new HtmlText(1)));
            }
            if (currentPageNo - 3 > 1 && pageCount > 8)
            {
                writeToOut("...");
            }
            int startPage = Math.max(currentPageNo - 3, 1);
            int endPage = Math.max(currentPageNo + 3, 7);
            endPage = Math.min(endPage, pageCount - 1);
            if (endPage - currentPageNo < 3)
            {
                int addNum = 3 - (endPage - currentPageNo - 1);
                startPage = Math.max(startPage - addNum + 1, 1);
            }
            for (int i = startPage; i <= endPage; i++)
            {
                if (currentPageNo == i)
                {
                    writeToOut(new HtmlTag("span", new HtmlText(i + 1)));
                }
                else
                {
                    HtmlTag link = new HtmlTag("a", new HtmlText(i + 1));
                    link.addAttribute("HREF", aUrl + "&pageNo=" + (i + 1));
                    writeToOut(link);
                }
            }

            if (currentPageNo + 4 < pageCount && pageCount > 8)
            {
                writeToOut("...");
            }
            if (currentPageNo < pageCount)
            {
                HtmlTag link = new HtmlTag("a", new HtmlText(pageCount + 1));
                link.addAttribute("href", aUrl + "&pageNo=" + (pageCount + 1));
                link.addAttribute("target", "_self");
                writeToOut(link);
                link = new HtmlTag("a", new HtmlText("下一页"));
                link.addAttribute("href", aUrl + "&pageNo="
                        + (currentPageNo + 2));
                link.addAttribute("target", "_self");
                link.addAttribute("class", nextClass);
                writeToOut(link);

            }
            else
            {
                writeToOut(new HtmlTag("span", new HtmlText(pageCount + 1)));
            }
        }
        return EVAL_BODY_INCLUDE;
    }

    public void setTotalCount(Integer totalCount)
    {
        this.totalCount = totalCount;
    }

    public void setCurrentPageNo(Integer currentPageNo)
    {
        this.currentPageNo = currentPageNo;
    }

    public void setCurrentPageUrl(String currentPageUrl)
    {
        this.currentPageUrl = currentPageUrl;
    }

    public void setPageNo(Integer pageNo)
    {
        this.currentPageNo = pageNo;
    }

    public void setPrevClass(String prevClass)
    {
        this.prevClass = prevClass;
    }

    public void setNextClass(String nextClass)
    {
        this.nextClass = nextClass;
    }

    public void setPerPage(Integer perPage)
    {
        this.perPage = perPage;
    }

}
