/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common;

import cn.pconline.search.common.Configuration;
import cn.pconline.search.common.SolrSearcher;
import cn.pconline.search.common.log.SearchLogger;
import cn.pconline.search.common.tools.ad.AdManager;
import cn.pconline.search.common.tools.homonym.Homonyms;
import cn.pconline.search.common.tools.sensitive.AnalyzeSensitiveFilter;
import cn.pconline.search.common.tools.sensitive.SensitiveFilter;
import cn.pconline.search.common.util.Mailer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SearchFrame {
    private volatile boolean inited = false;
    private static Logger logger = Logger.getLogger(SearchFrame.class);
    protected Configuration configuration;
    private SearchLogger searchLogger;
    private SolrSearcher searcher;
    private Homonyms homonyms;
    private SensitiveFilter sensitiveFilter;
    private AdManager adManager;
    private static SearchFrame instance = new SearchFrame();

    public synchronized void init(Configuration config) {
        if (this.inited) {
            return;
        }
        long start = System.currentTimeMillis();
        logger.debug((Object)("Init SearchFrame with config{" + config + "}"));
        this.configuration = config;
        if (config.getBooleanConfig("enableSearchLog", false).booleanValue()) {
            this.searchLogger = new SearchLogger(config);
        }
        this.searcher = new SolrSearcher(config);
        String homonymsFiles = config.getConfig("homonymsFiles", null);
        if (StringUtils.isNotBlank((String)homonymsFiles)) {
            this.homonyms = new Homonyms(homonymsFiles);
        }
        if (config.getBooleanConfig("enbaleSensitiveFilter", false).booleanValue()) {
            this.sensitiveFilter = new AnalyzeSensitiveFilter(config);
            logger.debug((Object)"finish load SensitiveFilter");
        }
        if (config.getBooleanConfig("enableAdManager", false).booleanValue()) {
            this.adManager = new AdManager(config);
            logger.debug((Object)"finish load AdManager");
        }
        logger.debug((Object)("SearchFrame init complete in " + (System.currentTimeMillis() - start) + " ms"));
        this.inited = true;
    }

    private SearchFrame() {
    }

    private void checkInit() {
        if (!this.inited) {
            throw new IllegalStateException("Frame has not been initialize or has been closed,pelease make sure has invoked #init# method");
        }
    }

    public static SearchFrame get() {
        return instance;
    }

    public SearchLogger getLogger() {
        this.checkInit();
        if (this.searchLogger == null) {
            throw new IllegalStateException("SearchLogger is not enable");
        }
        return this.searchLogger;
    }

    public SolrSearcher getSearcher() {
        this.checkInit();
        return this.searcher;
    }

    public Homonyms getHomonyms() {
        this.checkInit();
        return this.homonyms;
    }

    public String getHomonynsWords(String key) {
        this.checkInit();
        if (this.homonyms == null) {
            return "";
        }
        return this.homonyms.getHomonyms(key);
    }

    public SensitiveFilter getSensitiveFilter() {
        this.checkInit();
        if (this.sensitiveFilter == null) {
            throw new IllegalStateException("sensitive filter is not enable or load fail");
        }
        return this.sensitiveFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (!this.inited) {
            return;
        }
        try {
            this.searcher.close();
            this.searcher = null;
            if (this.searchLogger != null) {
                this.searchLogger.close();
            }
            this.searchLogger = null;
            this.homonyms = null;
        }
        finally {
            this.inited = false;
        }
    }

    public AdManager getAdManager() {
        this.checkInit();
        if (this.adManager == null) {
            throw new IllegalStateException("AdManager isn't enable!");
        }
        return this.adManager;
    }

    public void sendErrMail(String title, String errInfo) {
        this.checkInit();
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head></head><body><div><h1>\u73af\u5883\u4fe1\u606f:</h1><ul>");
        sb.append("<li>\u670d\u52a1\u5668:" + SearchFrame.getLocalAddress() + "</li>");
        sb.append("<li>\u65f6\u95f4:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "</li>");
        sb.append("<li></li>");
        sb.append("</ul></div>");
        sb.append("<div><h1>\u9519\u8bef\u4fe1\u606f</h1><div>");
        sb.append(errInfo);
        sb.append("</div></div></body></html>");
        Mailer.sendMail(title, sb.toString(), this.configuration.getConfig("mailServer"), this.configuration.getConfig("mailFrom"), this.configuration.getConfig("mailTo"), this.configuration.getConfig("mailUser"), this.configuration.getConfig("mailPassword"));
    }

    public boolean isAvaliable() {
        return this.inited;
    }

    public static String getLocalAddress() {
        Enumeration<NetworkInterface> netInterfaces = null;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    String ip = ips.nextElement().getHostAddress();
                    if (!ip.startsWith("192.") && !ip.startsWith("10.") && !ip.startsWith("172.")) continue;
                    return ip;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Try get local LAN IP error!", (Throwable)e);
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.error((Object)"Try get local LAN IP error!", (Throwable)e);
            return null;
        }
    }
}

