package cn.pconline.search.common.query;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.solr.client.solrj.response.QueryResponse;

/**
 * solr查询结果
 * 
 * @author zengjie
 * @since 2013-11-1
 * @see
 */
public class SolrQueryResult
{

    private QueryResponse source;

    private Map<String, Object> others;

    private SolrQueryResult(QueryResponse source)
    {
        super();
        this.source = source;
    }

    /**
     * 获取结果文档列表
     * 
     * @return
     */
    public List<? extends Map<String, Object>> getDocuments()
    {
        return source.getResults();
    }

    /**
     * 获取源结果
     * 
     * @return
     */
    public QueryResponse getSource()
    {
        return source;
    }

    /**
     * 获取查询匹配数量
     * 
     * @return
     */
    public long getTotal()
    {
        return source.getResults().getNumFound();
    }

    /**
     * 本次查询其他相关参数
     * 
     * @return
     */
    public Map<String, Object> getOtherParams()
    {
        return others != null ? others
                : (others = new HashMap<String, Object>());
    }

    public void setOtherParam(String key, Object value)
    {
        (others == null ? (others = new HashMap<String, Object>()) : others)
                .put(key, value);
    }

    public boolean getBooleanParam(String key)
    {
        return Boolean.parseBoolean(String.valueOf(getOtherParams().get(key)));
    }

    public String getStringParam(String key)
    {
        Object v = getOtherParams().get(key);
        return v == null ? null : String.valueOf(v);
    }

    public Integer getIntegerParam(String key)
    {
        Object v = getOtherParams().get(key);
        try
        {
            return v == null ? null : Integer.parseInt(String.valueOf(v));
        }
        catch (NumberFormatException e)
        {
            return null;
        }
    }

    public static SolrQueryResult fromResponse(QueryResponse response)
    {
        return new SolrQueryResult(response);
    }

}