package cn.pconline.search.common.taglib;

import javax.servlet.jsp.JspException;

import org.apache.commons.lang.StringUtils;

import com.alibaba.fastjson.JSON;

/**
 * 通过请求指定的url并且将返回字符串转成json对象供标签内代码使用
 * 
 * @author zengjie
 * @since 2013-9-26
 * @see
 */
public class SsiJsonTag extends SsiTag
{

    private static final long serialVersionUID = -4863432530415538772L;

    private String jsonKey;

    private Class<?> jsonType;

    @Override
    public int doStartTag() throws JspException
    {
        String useProxy = "n";
        String json = readHtml(useProxy);
        if (StringUtils.isBlank(json))
        {
            return SKIP_BODY;
        }
        pageContext.setAttribute(
                jsonKey,
                jsonType == null ? JSON.parseObject(json.trim()) : JSON
                        .parseObject(json, jsonType));
        return EVAL_BODY_INCLUDE;
    }

    public void setJsonKey(String jsonKey)
    {
        this.jsonKey = jsonKey;
    }

    public void setJsonType(Class<?> jsonType)
    {
        this.jsonType = jsonType;
    }
}
