package cn.pconline.search.common.tools.segment.bean;

import java.util.ArrayList;

import cn.pconline.search.common.tools.segment.utility.Utility;

public class SegResult {

	private long spendTime;
	
	private String rawContent;// 原始分词内容

	private ArrayList<MidResult> mrList;// 中间结果

	public SegResult(String rawContent) {
		this.rawContent = rawContent;
	}

	public ArrayList<SegNode> getSegNodeList() {
		ArrayList<SegNode> list=new ArrayList<SegNode>();
		int index=0;
		if(mrList!=null){
			for(MidResult mr:mrList){
				ArrayList<SegNode> finalSegPath= mr.getFinalSegPath();
				if(finalSegPath!=null){
					for(SegNode node: finalSegPath){
						if(node.getPos()==Utility.CT_SENTENCE_BEGIN||node.getPos()==Utility.CT_SENTENCE_END){
							continue;
						}
						int length=node.getRow()-node.getCol();
						SegNode newNode=node.clone();
						newNode.setRow(index);
						newNode.setCol(index+length);
						index=index+length;
						list.add(newNode);
					}
				}
			}
		}
		return list;
	}
	
	public String getFinalResult() {
		StringBuffer result=new StringBuffer();
		if(mrList!=null){
			for(MidResult mr:mrList){
				ArrayList<SegNode> finalSegPath= mr.getFinalSegPath();
				if(finalSegPath!=null){
					if(result.length()!=0) result.append(" ");
					result.append(MidResult.outputResult(finalSegPath));
				}else{
					result.append(mr.getSource());
				}
			}
		}
		return result.toString();
	}

	public ArrayList<MidResult> getMrList() {
		return mrList;
	}

	public void setMrList(ArrayList<MidResult> mrList) {
		this.mrList = mrList;
	}

	public String getRawContent() {
		return rawContent;
	}

	public void setRawContent(String rawContent) {
		this.rawContent = rawContent;
	}

	public long getSpendTime() {
		return spendTime;
	}

	public void addMidResult(MidResult mr) {
		if (mrList == null)
			mrList = new ArrayList<MidResult>();
		if (mr != null)
			mrList.add(mr);
	}

	public String toHTML() {
		StringBuffer html = new StringBuffer();

		if (rawContent != null) {
			html.append("原文内容：");
			html.append("<table border=\"1\" width=\"100%\"><tr><td width=\"100%\">");
			html.append(rawContent);
			html.append("</td></tr></table>");

			if (mrList != null) {
				for (MidResult mr : mrList) {
					html.append(mr.toHTML());
				}
			}
            String finalResult = getFinalResult();
			if (finalResult != null && finalResult.trim().length()>0) {
				html.append("<p>最终分词结果：");
				html.append("<table border=\"1\" width=\"100%\"><tr><td width=\"100%\">");
				html.append("<font color=\"blue\" size=6><b>" + finalResult + "</b></font>");
				html.append("</td></tr></table>");
			}
		}

		return html.toString();

	}

	public void setSpendTime(long spendTime) {
		this.spendTime = spendTime;
	}
}
