package cn.pconline.search.common.ks;

import java.util.List;
import java.util.Map;

/**
 * 搜索快搜返回的结果对象
 * 
 * @author zengjie
 * @since 2013-9-26
 * @see
 */
public class KSResult
{

    private int total;

    private int time;

    private List<Map<String, Object>> documents;

    private int start;

    private int curPage;

    private int perPage;

    private Map<String, List<String>> statistic;

    public int getTotal()
    {
        return total;
    }

    public void setTotal(int total)
    {
        this.total = total;
    }

    public int getTime()
    {
        return time;
    }

    public void setTime(int time)
    {
        this.time = time;
    }

    public List<Map<String, Object>> getDocuments()
    {
        return documents;
    }

    public void setDocuments(List<Map<String, Object>> documents)
    {
        this.documents = documents;
    }

    public int getStart()
    {
        return start;
    }

    public void setStart(int start)
    {
        this.start = start;
    }

    public int getCurPage()
    {
        return curPage;
    }

    public void setCurPage(int curPage)
    {
        this.curPage = curPage;
    }

    public int getPerPage()
    {
        return perPage;
    }

    public void setPerPage(int perPage)
    {
        this.perPage = perPage;
    }

    public Map<String, List<String>> getStatistic()
    {
        return statistic;
    }

    public void setStatistic(Map<String, List<String>> statistic)
    {
        this.statistic = statistic;
    }

    /**
     * 根据指定每页数量获取总页数
     * 
     * @param countPerPage
     * @return
     */
    public int getPageCount(int countPerPage)
    {
        if (total <= 0)
        {
            return 0;
        }
        if (total <= countPerPage)
        {
            return 1;
        }
        int count = total / countPerPage;
        if (total % countPerPage > 0) count++;
        return count;
    }

    @Override
    public String toString()
    {
        return "KSResult [total=" + total + ", time=" + time + ", documents="
                + documents + ", start=" + start + ", curPage=" + curPage
                + ", perPage=" + perPage + ", statistic=" + statistic + "]";
    }

}
