package cn.pconline.search.common.tools.segment.bean;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import cn.pconline.search.common.tools.segment.utility.GFCommon;
import cn.pconline.search.common.tools.segment.utility.GFString;
import cn.pconline.search.common.tools.segment.utility.Utility;


public class Dictionary {
	
	private Map<String,ArrayList<WordItem>> map=new HashMap<String,ArrayList<WordItem>>();
	
	private ArrayList<WordItem> emptyList=new ArrayList<WordItem>();
	
	public Dictionary() {
	}

	public Dictionary(String filename) throws IOException {
		load(filename);
	}

	public void load(String filename) throws IOException {
		load(filename, false);
	}

	
	
	/**
	 * 从词典表中加载词条.共6768个大的数据块(包括5个非汉字字符),每个大数据块包括若干个小数据块,
	 * 每个小数据块为一个词条,该数据块中每个词条都是共一个字开头的.
	 * 
	 * @param filename
	 *            核心词典文件名
	 * @param isReset
	 *            是否要重置
	 * @return
	 * @throws IOException 
	 */
	public void load(String filename, boolean isReset) throws IOException {
		File file;

		int[] nBuffer = new int[3];

		file = new File(filename);
		DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
		for (int i = 0; i < Utility.CC_NUM; i++) {
			// logger.debug("块" + i);
			// 词典库在写二进制数据时采用低位优先(小头在前)方式,需要转换一下
			int count = GFCommon.bytes2int(Utility.readBytes(in, 4), false);
			// logger.debug(" count:" + count);
			if (count <= 0)
				continue;

			for (int j = 0; j < count; j++) {
				nBuffer[0] = GFCommon.bytes2int(Utility.readBytes(in, 4), false);
				nBuffer[1] = GFCommon.bytes2int(Utility.readBytes(in, 4), false);
				nBuffer[2] = GFCommon.bytes2int(Utility.readBytes(in, 4), false);

				// String print = " wordLen:" + nBuffer[1] + " frequency:" +
				// nBuffer[0] + " handle:" + nBuffer[2];

				WordItem ti = new WordItem();
				if (nBuffer[1] > 0)// String length is more than 0
				{
					byte[] word = Utility.readBytes(in, nBuffer[1]);
					ti.setWord(new String(word, "GBK"));

				} else
					ti.setWord("");

				// print += " word:(" + Utility.getGB(i) + ")" +
				// ti.getWord();
				// logger.debug(print);

				if (isReset)// Reset the frequency
					ti.setFreq(0);
				else
					ti.setFreq(nBuffer[0]);
				ti.setLen(nBuffer[1] / 2);
				ti.setHandle(nBuffer[2]);
				/************/
				String str=ti.getWord();
				if(i!=3755){
					String c=Utility.getGB(i);
					str=c+str;
				}
				ArrayList<WordItem> l=map.get(str);
				if(l==null||emptyList==l){
					l=new ArrayList<WordItem>();
					map.put(str, l);
				}
				//ti.setWord(c+ti.getWord());
				l.add(ti);
				String[] ss=str.split("");
				String s="";
				for(String s1:ss){
					if(s1.length()>0){
						s+=s1;
						if(map.get(s)==null){
							map.put(s, emptyList);
						}
					}
				}
				/************/
			}
		}

		in.close();
	}
	
	public boolean isExist(String word, int handle) {
		if (word != null) {
			ArrayList<WordItem> l= getHandle(word);
			if(l!=null){
				for(WordItem wi:l){
					if(wi.getHandle()==handle){
						return true;
					}
				}
			}
		}
		return false;
	}

	public ArrayList<WordItem> getHandle(String word) {
		if (word != null) {
		    return  map.get(word);
		}
		return null;
	}
	
	public boolean strEqual(String b1, String b2) {
		if (b1 == null && b2 == null)
			return true;
		else if (b1 != null && b2 != null) {
			return b1.equals(b2);
		}
		return false;
	}

	public int getWordType(String word) {
		if (word != null) {
			int type = Utility.charType(word);
			int len = word.length();

			if (len > 0 && type == Utility.CT_CHINESE && GFString.isAllChinese(word))
				return Utility.WT_CHINESE;
			else if (len > 0 && type == Utility.CT_DELIMITER)
				return Utility.WT_DELIMITER;

		}
		return Utility.WT_OTHER;
	}

	public int getFreq(String word, int handle) {
		if (word != null && word.length() > 0) {
			ArrayList<WordItem> l= getHandle(word);
			if(l!=null){
				for(WordItem wi:l){
					if(wi.getHandle()==handle){
						return wi.getFreq();
					}
				}
			}
		}
		return 0;
	}

}
