package cn.pconline.search.common.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.params.ConnRoutePNames;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.CoreConnectionPNames;
import org.apache.http.params.HttpParams;
import org.apache.log4j.Logger;

import cn.pconline.r.client.SimpleHttpTemplate;
import cn.pconline.r.route.Route;

@SuppressWarnings("deprecation")
public class Intf
{

    private static Logger logger = Logger.getLogger(Intf.class);

    public static String DEFAULT_ENCODING = "GBK";

    public static int TIME_OUT = 30000; // 设置超时时间(毫秒)

    public static int CONNECT_TIME_OUT = 30000; // 设置超时时间(毫秒)

    public static int MAX_TOTAL_CONNECT = 80; // 总的连接数

    public static int RETRY_HANDLER_LIMIT = 1; // 超时重试次数

    public static String[] DEFAULT_PROXY_CONFIG = new String[] {
            "192.168.239.200", "1080", "pic", "iLualt" };

    public static String DEFAULT_REFERER_VALUE = "http://ks.pconline.com.cn";

    public static String REFERER_KEY = "Referer";

    private static SimpleHttpTemplate httpTemplate;

    static
    {
        Context context = null;
        try
        {
            context = new InitialContext();
            Object obj = context.lookup("java:comp/env/jca/pc_route");
            if (obj != null && (obj instanceof Route))
            {
                httpTemplate = new SimpleHttpTemplate();
                httpTemplate.setClientUri(DEFAULT_REFERER_VALUE);
                httpTemplate.setConnectTimeout(CONNECT_TIME_OUT);
                httpTemplate.setMaxPerRoute(3);
                httpTemplate.setMaxTotalConnections(MAX_TOTAL_CONNECT);
                httpTemplate.setReadTimeout(TIME_OUT);
                httpTemplate.setRoute((Route) obj);
                httpTemplate.init();
            }
        }
        catch (Throwable e)
        {
            logger.error(e.getMessage(), e);
        }
        finally
        {
            if (context != null)
            {
                try
                {
                    context.close();
                }
                catch (NamingException e)
                {
                    logger.error("close context error", e);
                }
            }
        }

    }

    private static HttpClient client; // 没有使用代理访问

    private static HttpClient client4Proxy; // 使用代理访问

    private static void genHttpClient(String[] proxyConfig, int timeout,
            int retry)
    {
        if (proxyConfig != null && proxyConfig.length == 4)
        {
            if (client4Proxy == null)
            {
                HttpParams params = new BasicHttpParams();
                params.setParameter(CoreConnectionPNames.CONNECTION_TIMEOUT,
                        CONNECT_TIME_OUT);
                params.setParameter(CoreConnectionPNames.SO_TIMEOUT, TIME_OUT);

                ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager();
                manager.setMaxTotal(MAX_TOTAL_CONNECT);
                client4Proxy = new DefaultHttpClient(manager, params);
                // 使用代理访问
                HttpHost proxy = new HttpHost(proxyConfig[0],
                        Integer.parseInt(proxyConfig[1]));
                client4Proxy.getParams().setParameter(
                        ConnRoutePNames.DEFAULT_PROXY, proxy);
                Credentials credentials = new NTCredentials(proxyConfig[2],
                        proxyConfig[3], "", "");
                ((DefaultHttpClient) client4Proxy).getCredentialsProvider()
                        .setCredentials(AuthScope.ANY, credentials);
                logger.info(proxyConfig[0] + "," + proxyConfig[1] + ","
                        + proxyConfig[0] + "," + proxyConfig[2] + ","
                        + proxyConfig[3]);
            }
            if (retry > 0)
            {
                ((DefaultHttpClient) client4Proxy)
                        .setHttpRequestRetryHandler(new DefaultHttpRequestRetryHandler(
                                retry, true));
            }
        }
        else
        {
            if (client == null)
            {
                HttpParams params = new BasicHttpParams();
                params.setParameter(CoreConnectionPNames.CONNECTION_TIMEOUT,
                        CONNECT_TIME_OUT);
                params.setParameter(CoreConnectionPNames.SO_TIMEOUT, TIME_OUT);

                ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager();
                manager.setMaxTotal(MAX_TOTAL_CONNECT);
                client = new DefaultHttpClient(manager, params);
            }
            if (retry > 0)
            {
                ((DefaultHttpClient) client)
                        .setHttpRequestRetryHandler(new DefaultHttpRequestRetryHandler(
                                retry, true));
            }
        }
    }

    private static HttpClient genSingleHttpClient(String[] proxyConfig,
            String charset, int timeout, int retry)
    {
        DefaultHttpClient singleClient = new DefaultHttpClient();
        if (proxyConfig != null && proxyConfig.length == 4)
        {
            // 使用代理访问
            HttpHost proxy = new HttpHost(proxyConfig[0],
                    Integer.parseInt(proxyConfig[1]));
            singleClient.getParams().setParameter(
                    ConnRoutePNames.DEFAULT_PROXY, proxy);
            Credentials credentials = new NTCredentials(proxyConfig[2],
                    proxyConfig[3], "", "");
            singleClient.getCredentialsProvider().setCredentials(AuthScope.ANY,
                    credentials);
            logger.info(proxyConfig[0] + "," + proxyConfig[1] + ","
                    + proxyConfig[0] + "," + proxyConfig[2] + ","
                    + proxyConfig[3]);
        }
        singleClient.getParams().setParameter(
                "http.protocol.element-charset",
                (charset != null && charset.trim().length() > 0) ? charset
                        : DEFAULT_ENCODING);
        singleClient.getParams().setParameter(
                "http.protocol.content-charset",
                (charset != null && charset.trim().length() > 0) ? charset
                        : DEFAULT_ENCODING);
        singleClient.getParams().setParameter(
                CoreConnectionPNames.CONNECTION_TIMEOUT,
                timeout > 0 ? timeout : CONNECT_TIME_OUT);
        singleClient.getParams().setParameter(CoreConnectionPNames.SO_TIMEOUT,
                timeout > 0 ? timeout : TIME_OUT);
        if (retry > 0)
        {
            ((DefaultHttpClient) client4Proxy)
                    .setHttpRequestRetryHandler(new DefaultHttpRequestRetryHandler(
                            retry, true));
        }
        return singleClient;
    }

    /**
     * 使用HttpClient的GET方式
     * 
     * @param url
     * @param proxyConfig
     *            {proxyHost,proxyPort,userName,password}
     * @return String
     * @throws IOException
     */
    public static String readHtml4Get(String url, String[] proxyConfig)
            throws IOException
    {
        return readHtml4Get(url, proxyConfig, DEFAULT_ENCODING, TIME_OUT,
                RETRY_HANDLER_LIMIT);
    }

    /**
     * 使用HttpClient的GET方式
     * 
     * @param url
     * @param proxyConfig
     *            {proxyHost,proxyPort,userName,password}
     * @param charset
     * @param timeout
     * @param retry
     * @return String
     * @throws IOException
     */
    public static String readHtml4Get(String url, String[] proxyConfig,
            String charset, int timeout, int retry) throws IOException
    {
        if (httpTemplate != null)
        {
            return httpTemplate.get(url, DEFAULT_REFERER_VALUE);
        }
        if (proxyConfig != null && proxyConfig.length != 4) throw new IOException(
                "proxy config error");
        boolean isUseProxy = (proxyConfig != null && proxyConfig.length == 4);
        genHttpClient(proxyConfig, timeout, retry);
        HttpRequestBase method = new HttpGet(url);
        try
        {
            method.addHeader(new BasicHeader(REFERER_KEY, DEFAULT_REFERER_VALUE));
            method.addHeader(new BasicHeader("Host", method.getURI().getHost()));
            method.addHeader(new BasicHeader(
                    "User-Agent",
                    "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/29.0.1547.66 Safari/537.36"));
            // Referer
            logger.debug("readHtml4Get url: " + url);
            HttpResponse rsp = isUseProxy ? client4Proxy.execute(method)
                    : client.execute(method);
            // Read the response body.
            byte[] responseBody = IOUtils.toByteArray(rsp.getEntity()
                    .getContent());
            String html = new String(responseBody, charset).replaceAll(
                    "\n\\s+", "\n").replaceFirst("^\\s+\n", "");
            // Check that we didn't run out of retries.
            if (rsp.getStatusLine().getStatusCode() != HttpStatus.SC_OK
                    && rsp.getStatusLine().getStatusCode() != HttpStatus.SC_NOT_MODIFIED)
            {
                throw new IOException("readHtml4Get error HttpStatus:"
                        + rsp.getStatusLine().getStatusCode() + " "
                        + rsp.getStatusLine().getReasonPhrase()
                        + "\n from url:" + url + filterHtmlTag(html));
            }
            if (html.indexOf("Servlet Exception") != -1)
            {
                throw new IOException("readHtml4Get Servlet Exception:"
                        + rsp.getStatusLine().getStatusCode() + " "
                        + rsp.getStatusLine().getReasonPhrase()
                        + "\n from url:" + url + filterHtmlTag(html));
            }
            return html;
        }
        finally
        {
            method.abort();
        }
    }

    // /**
    // * 检查URL中参数没有encode而带有空格，会自动将参数encode
    // * （主要是对使用HttpClient的GET方式，URL中参数没有encode而带有空格，会被过滤的BUG）
    // *
    // * @param url
    // * @param charset
    // * @return
    // */
    // private static String encodeGetUrl(String url, String charset)
    // {
    // String enurl = url;
    // if (StringUtils.isNotBlank(url))
    // {
    // String tmpurl = url.trim();
    // if (tmpurl.indexOf("?") != -1 && tmpurl.indexOf(" ") != -1)
    // {
    // String[] ss = tmpurl.split("\\?");
    // String uroot = ss[0];
    // String parms = "";
    // if (ss.length == 2)
    // {
    // String[] qpss = ss[1].split("&");
    // for (String p : qpss)
    // {
    // if (StringUtils.isNotBlank(p))
    // {
    // if (p.indexOf("=") != -1)
    // {
    // String[] psss = p.split("=");
    // if (psss.length == 2)
    // {
    // if (StringUtils.isNotBlank(psss[1]))
    // {
    // try
    // {
    // parms += psss[0]
    // + "="
    // + URLEncoder.encode(
    // psss[1], charset)
    // + "&";
    // }
    // catch (UnsupportedEncodingException e)
    // {
    // }
    // }
    // }
    // }
    // else
    // {
    // try
    // {
    // parms += URLEncoder.encode(p, charset)
    // + "&";
    // }
    // catch (UnsupportedEncodingException e)
    // {
    // }
    // }
    // }
    // }
    // enurl = (uroot + "?" + parms).replaceFirst("&$", "");
    // }
    // }
    // }
    // logger.debug("encodeGetUrl url: " + enurl);
    // return enurl;
    // }

    /**
     * 使用HttpClient的POST方式
     * 
     * @param url
     * @param proxyConfig
     *            {proxyHost,proxyPort,userName,password}
     * @param params
     * @return String
     * @throws IOException
     */
    public static String readHtml4Post(String url, String[] proxyConfig,
            Map<String, Object> params) throws IOException
    {
        return readHtml4Post(url, proxyConfig, params, DEFAULT_ENCODING,
                TIME_OUT, RETRY_HANDLER_LIMIT);
    }

    /**
     * 使用HttpClient的POST方式
     * 
     * @param url
     * @param proxyConfig
     *            {proxyHost,proxyPort,userName,password}
     * @param params
     * @param charset
     * @param timeout
     * @param retry
     * @return String
     * @throws IOException
     */
    public static String readHtml4Post(String url, String[] proxyConfig,
            Map<String, Object> params, String charset, int timeout, int retry)
            throws IOException
    {
        if (proxyConfig != null && proxyConfig.length != 4) throw new IOException(
                "proxy config error");
        boolean isUseProxy = (proxyConfig != null && proxyConfig.length == 4);
        genHttpClient(proxyConfig, timeout, retry);
        HttpPost method = new HttpPost(url);
        try
        {
            method.addHeader(new BasicHeader(REFERER_KEY,
                    (params != null ? stringValue(
                            (String) params.get(REFERER_KEY),
                            DEFAULT_REFERER_VALUE) : DEFAULT_REFERER_VALUE))); // 设置Header
                                                                               // Referer
            StringBuffer _sbposturl = new StringBuffer(url).append("?");
            HttpEntity entity = null;
            if (params != null)
            {
                List<NameValuePair> pairs = new ArrayList<NameValuePair>();
                params.remove(REFERER_KEY); // 删Header Referer
                Iterator<String> paramKeys = params.keySet().iterator();
                while (paramKeys.hasNext())
                {
                    String paramName = paramKeys.next();
                    String paramValue = null;
                    if (params.get(paramName) instanceof String[])
                    {
                        String[] pss = (String[]) params.get(paramName);
                        for (int i = 0; pss != null && i < pss.length; ++i)
                        {
                            paramValue = pss[i];
                            _sbposturl.append(paramName + "=" + paramValue)
                                    .append("&");
                            if (paramValue != null)
                            {
                                pairs.add(new BasicNameValuePair(paramName,
                                        paramValue));
                            }
                        }
                    }
                    else
                    {
                        paramValue = String.valueOf(params.get(paramName));
                        _sbposturl.append(paramName + "=" + paramValue).append(
                                "&");
                        if (paramValue != null)
                        {
                            pairs.add(new BasicNameValuePair(paramName,
                                    paramValue));
                        }
                    }
                }
                entity = new UrlEncodedFormEntity(pairs, charset);
            }
            // 使用R系统调用
            if (httpTemplate != null)
            {
                return httpTemplate.post(url, null, null, entity);
            }
            method.setEntity(entity);
            logger.debug("readHtml4Post url: " + _sbposturl.toString());
            HttpResponse rsp = isUseProxy ? client4Proxy.execute(method)
                    : client.execute(method);
            // Read the response body.
            byte[] responseBody = IOUtils.toByteArray(rsp.getEntity()
                    .getContent());
            String html = new String(responseBody, DEFAULT_ENCODING)
                    .replaceAll("\n\\s+", "\n").replaceFirst("^\\s+\n", "");
            // Check that we didn't run out of retries.
            if (rsp.getStatusLine().getStatusCode() != HttpStatus.SC_OK
                    && rsp.getStatusLine().getStatusCode() != HttpStatus.SC_NOT_MODIFIED)
            {
                throw new IOException("readHtml4Post error HttpStatus:"
                        + rsp.getStatusLine().getStatusCode() + " "
                        + rsp.getStatusLine().getReasonPhrase()
                        + "\n from url:" + _sbposturl.toString() + "\n"
                        + filterHtmlTag(html));
            }
            if (html.indexOf("Servlet Exception") != -1)
            {
                throw new IOException("readHtml4Post Servlet Exception:"
                        + rsp.getStatusLine().getStatusCode() + " "
                        + rsp.getStatusLine().getReasonPhrase()
                        + "\n from url:" + _sbposturl.toString() + "\n"
                        + filterHtmlTag(html));
            }
            return html;
        }
        finally
        {
            method.abort();
        }
    }

    public static String uploadMultipartPost(String url, String[] proxyConfig,
            Map<String, Object> params, String charset, int timeout, int retry)
            throws IOException
    {
        if (proxyConfig != null && proxyConfig.length != 4) throw new IOException(
                "proxy config error");
        // boolean isUseProxy = (proxyConfig != null && proxyConfig.length ==
        // 4);
        HttpClient singleClient = genSingleHttpClient(proxyConfig, charset,
                timeout, retry);
        HttpPost method = null;
        try
        {
            method = new HttpPost(url);
            method.addHeader(new BasicHeader(REFERER_KEY,
                    (params != null ? stringValue(
                            (String) params.get(REFERER_KEY),
                            DEFAULT_REFERER_VALUE) : DEFAULT_REFERER_VALUE))); // 设置Header
                                                                               // Referer
            StringBuffer _sbposturl = new StringBuffer(url).append("?");
            if (params != null)
            {
                params.remove(REFERER_KEY); // 删Header Referer
                MultipartEntity entity = new MultipartEntity();
                Iterator<String> paramKeys = params.keySet().iterator();
                while (paramKeys.hasNext())
                {
                    String paramName = paramKeys.next();
                    String paramValue = null;
                    if (params.get(paramName) instanceof String[])
                    {
                        String[] pss = (String[]) params.get(paramName);
                        if (pss == null) continue;
                        for (String ps : pss)
                        {
                            paramValue = ps;
                            _sbposturl.append(paramName + "=" + paramValue)
                                    .append("&");
                            if (paramValue != null)
                            {
                                entity.addPart(new FormBodyPart(paramName,
                                        new StringBody(paramValue)));
                            }
                        }
                    }
                    else if (params.get(paramName) instanceof File[])
                    {
                        File[] pff = (File[]) params.get(paramName);
                        if (pff == null) continue;
                        for (File pf : pff)
                        {
                            paramValue = pf.getName();
                            _sbposturl.append(paramName + "=" + paramValue)
                                    .append("&");
                            if (pf != null)
                            {
                                entity.addPart(new FormBodyPart(paramName,
                                        new FileBody(pf)));
                            }
                        }
                    }
                    else
                    {
                        paramValue = String.valueOf(params.get(paramName));
                        _sbposturl.append(paramName + "=" + paramValue).append(
                                "&");
                        if (paramValue != null)
                        {
                            entity.addPart(new FormBodyPart(paramName,
                                    new StringBody(paramValue)));
                        }
                    }
                }
                method.setEntity(entity);
            }
            logger.debug("uploadMultipartPost url: " + _sbposturl.toString());
            HttpResponse rsp = singleClient.execute(method);
            // Read the response body.
            byte[] responseBody = IOUtils.toByteArray(rsp.getEntity()
                    .getContent());
            String html = new String(responseBody, DEFAULT_ENCODING)
                    .replaceAll("\n\\s+", "\n").replaceFirst("^\\s+\n", "");
            if (rsp.getStatusLine().getStatusCode() != HttpStatus.SC_OK
                    && rsp.getStatusLine().getStatusCode() != HttpStatus.SC_NOT_MODIFIED)
            {
                throw new IOException("uploadMultipartPost error HttpStatus:"
                        + rsp.getStatusLine().getStatusCode() + " "
                        + rsp.getStatusLine().getReasonPhrase()
                        + "\n from url:" + _sbposturl.toString() + "\n"
                        + filterHtmlTag(html));
            }
            if (html.indexOf("Servlet Exception") != -1)
            {
                throw new IOException("uploadMultipartPost Servlet Exception:"
                        + rsp.getStatusLine().getStatusCode() + " "
                        + rsp.getStatusLine().getReasonPhrase()
                        + "\n from url:" + _sbposturl.toString() + "\n"
                        + filterHtmlTag(html));
            }
            return html;
        }
        finally
        {
            method.abort();
        }
    }

    private static String filterHtmlTag(String text)
    {
        if (text == null) return "";
        // 清除script标签内容，以及其他HTML tag
        Matcher m = Pattern.compile("(?i)<pre\\s*>([\\s\\S]*?)</pre\\s*>")
                .matcher(text);
        if (m.find(0)) text = text.replaceAll(
                "(?si).*<pre\\s*>([\\s\\S]*?)</pre\\s*>.*", "$1");
        text = text
                .replaceAll("(?si)<\\s*\\bscript\\b(.*?)>(.*?)</script>", "")
                .replaceAll("(?si)<\\s*\\bstyle\\b(.*?)>(.*?)</style>", "")
                .replaceAll("(?s)<\\s*[\\w|/][^>]*>", "")
                .replaceAll("<\\!DOCTYPE\\s+[^>]*>", "")
                .replaceAll("&nbsp;", " ").replaceAll("\n\\s+", "\n")
                .replaceFirst("^\\s+\n", "");
        return text;
    }

    private static String stringValue(String v, String def)
    {
        if (StringUtils.isBlank(v)) return def;
        return v.trim();
    }

    /**
     * 获取进行R系统调用的 {@link SimpleHttpTemplate}对象
     * 
     * @return 如果JNDI中未配置R系统相关参数，返回null
     */
    public static SimpleHttpTemplate getHttpTemplate()
    {
        return httpTemplate;
    }
}