package cn.pconline.search.common.tools.generalization2;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import cn.pconline.search.common.tools.semantic2.SemanticResult;
import cn.pconline.search.common.tools.semantic2.SemanticWord;

/**
 * 用来表示多个维度的过滤
 * 
 * @author zengjie
 * @since 2013-9-16
 * @see
 */
public class Dimensions
{

    private Map<String, SingleDimension> dimensionMap = new HashMap<String, SingleDimension>();

    public void addDimension(SingleDimension dimension)
    {
        dimensionMap.put(dimension.getField(), dimension);
    }

    public SingleDimension getDimension(String field)
    {
        return dimensionMap.get(field);
    }

    public Map<String, SingleDimension> getDimensionMap()
    {
        return dimensionMap;
    }

    @Override
    public String toString()
    {
        return "Dimensions [dimensionMap=" + dimensionMap + "]";
    }

    public String toSolrQuery(boolean filterAll)
    {
        if (dimensionMap.isEmpty())
        {
            return "";
        }
        StringBuilder content = new StringBuilder();
        int index = 0;
        for (Entry<String, SingleDimension> en : dimensionMap.entrySet())
        {
            if (index != 0)
            {
                content.append(" ");
            }
            index++;
            SemanticResult result = en.getValue().getFilter();
            content.append((filterAll ? "+" : "") + en.getValue().getField()
                    + ":(");
            for (SemanticWord word : result.getWords())
            {
                content.append(word.getWord()).append("^")
                        .append(word.getBoost()).append(" ");
            }
            content.append(")");
        }
        return content.toString();
    }
}
