package cn.pconline.search.common.web;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

import org.apache.commons.lang.StringUtils;

import cn.pconline.search.common.Configuration;
import cn.pconline.search.common.SearchFrame;
import cn.pconline.search.common.util.Config;

/**
 * 搜索初始化Servlet
 * <p>
 * 配置load-on-startup 为1
 * </p>
 * 
 * @author zengjie
 * @since 2013-9-24
 * @see
 */
public class SearchInitServlet extends HttpServlet
{

    private static final long serialVersionUID = -2080525595052481383L;

    private static Configuration config;

    /**
     * 框架配置文件，会根据指定的servlet配置在当前classpah中查找配置文件并加载，如果没有配置则默认使用
     * {@link Config#getDefaultConfig()}
     */
    public static final String FRAME_CONFIG_PARAM_KEY = "config-file";

    public void init() throws ServletException
    {
        String configFile = getServletConfig().getInitParameter(
                FRAME_CONFIG_PARAM_KEY);
        if (StringUtils.isEmpty(configFile))
        {
            config = Config.getDefaultConfig();
        }
        else
        {
            config = new Config(configFile);
        }
        SearchFrame.get().init(config);
    }

    @Override
    public void destroy()
    {
        if (SearchFrame.get().isAvaliable())
        {
            SearchFrame.get().shutdown();
        }
    }

    /**
     * 获取当前web应用搜索使用的配置对象
     * 
     * @return
     */
    public static Configuration getAppConfig()
    {
        return config;
    }
}
