package cn.pconline.search.common.log;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

/**
 * A counter like sql count(*) from table group by. quick for get top numbers.
 * 
 * @author chen xiaohu
 */
public class GroupCounter
{

    private Map<SearchLog, Counter> items;

    public GroupCounter()
    {
        items = new HashMap<SearchLog, Counter>();
    }

    public void add(SearchLog item)
    {

        Counter counter = (Counter) items.get(item);
        if (counter == null)
        {
            items.put(item, new Counter(1));
        }
        else
        {
            counter.count++;
        }

    }

    public Map<SearchLog, Counter> getItems()
    {
        return items;
    }

    public List<Item> getTop(int top)
    {
        return top(items, top);
    }

    /**
     * 计算计数信息的前指定条数，使用二分发，适用于200条以上
     * 
     * @param counter
     *            计数信息
     * @param num
     *            头条数
     * @return
     */
    private static List<Item> top(Map<SearchLog, Counter> counter, int num)
    {
        List<Item> result = new ArrayList<Item>();
        result.add(Item.ZERO);
        boolean full = false;
        for (Iterator<SearchLog> it = counter.keySet().iterator(); it.hasNext();)
        {
            SearchLog key = it.next();
            int count = ((Counter) counter.get(key)).count;

            Item item = new Item(key, count);
            int index = Collections.binarySearch(result, item);
            if (index == -1 || index == 0) continue;
            if (index < 1) index = -index - 1;
            result.add(index, item);

            if (!full)
            {
                if (result.size() == num) full = true;
            }
            else
            {
                result.remove(0);
            }
        }

        if (result.get(0) == Item.ZERO) result.remove(0);
        Collections.reverse(result);
        return result;
    }

    /**
     * 用于排头条的数据结构，支持二分法排序
     * 
     * @author chen xiaohu
     * 
     */
    public static class Item implements Comparable<Item>
    {

        private static final String SEP = ":";

        private SearchLog key;

        private int count;

        public final static Item ZERO = new Item(
                new SearchLog(null, "zero", 0), -1);

        public Item(SearchLog key, int count)
        {
            this.key = key;
            this.count = count;
        }

        public int getCount()
        {
            return count;
        }

        public void setCount(int count)
        {
            this.count = count;
        }

        public SearchLog getKey()
        {
            return key;
        }

        public void setKey(SearchLog key)
        {
            this.key = key;
        }

        public String toString()
        {
            StringBuffer buf = new StringBuffer();
            buf.append(count).append(SEP).append(key);
            String result = buf.toString();

            return result;
        }

        public int compareTo(Item o)
        {
            Item item = (Item) o;
            int thisVal = this.count;
            int anotherVal = item.count;
            return (thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1));
        }
    }

    /**
     * A mutable integer to use by java collection
     * 
     * @author chen xiaohu
     */
    public static class Counter
    {

        public int count = 0;

        public Counter(int count)
        {
            this.count = count;
        }
    }

}
