package cn.pconline.search.common.log;

import java.util.Date;

/**
 * 表示单条搜索日志记录
 * 
 * @author zengjie
 * @since 2013-9-23
 * @see
 */
public class SearchLog
{

    private String app;

    private String key;

    private int retCount;

    private Date searchTime = new Date();

    public SearchLog()
    {
    }

    public SearchLog(String app, String name, int retCount)
    {
        super();
        this.app = app;
        this.key = name;
        this.retCount = retCount;
    }

    public String getApp()
    {
        return app;
    }

    public void setApp(String app)
    {
        this.app = app;
    }

    public String getKey()
    {
        return key;
    }

    public void setKey(String key)
    {
        this.key = key;
    }

    public int getRetCount()
    {
        return retCount;
    }

    public void setRetCount(int retCount)
    {
        this.retCount = retCount;
    }

    public Date getSearchTime()
    {
        return searchTime;
    }

    public void setSearchTime(Date searchTime)
    {
        this.searchTime = searchTime;
    }

    @Override
    public int hashCode()
    {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((app == null) ? 0 : app.hashCode());
        result = prime * result + ((key == null) ? 0 : key.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj)
    {
        if (this == obj) return true;
        if (obj == null) return false;
        if (getClass() != obj.getClass()) return false;
        SearchLog other = (SearchLog) obj;
        if (app == null)
        {
            if (other.app != null) return false;
        }
        else if (!app.equals(other.app)) return false;
        if (key == null)
        {
            if (other.key != null) return false;
        }
        else if (!key.equals(other.key)) return false;
        return true;
    }

    @Override
    public String toString()
    {
        return "SearchLog [app=" + app + ", name=" + key + ", retCount="
                + retCount + ", searchTime=" + searchTime + "]";
    }

}
