package cn.pconline.search.common.query.elements;

/**
 * PharseQuery查询
 * 
 * @author zengjie
 * @since 2013-11-29
 * @see
 */
public class Pharse extends TextQuery
{

    private int slop;

    public Pharse(String key, float boost, int slop, Object... values)
    {
        super(key, boost, values);
        this.slop = slop;
    }

    public Pharse(String key, Object... values)
    {
        this(key, 1F, 0, values);
    }

    public int getSlop()
    {
        return slop;
    }

    public Pharse setSlop(int slop)
    {
        this.slop = slop;
        return this;
    }

    @Override
    protected void getMultiStrValue(StringBuilder out, Object[] values)
    {
        out.append("\"");
        super.getMultiStrValue(out, values);
        out.append("\"");
        if (slop > 0)
        {
            out.append("~").append(slop);
        }
    }

}
