/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common;

import cn.pconline.search.common.Configuration;
import cn.pconline.search.common.SearchException;
import cn.pconline.search.common.ks.KSResult;
import cn.pconline.search.common.query.SolrQueryResult;
import cn.pconline.search.common.util.HttpUrl;
import cn.pconline.search.common.util.Intf;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;

public class SolrSearcher {
    public static final String DEFAULT_SOLR_URL = "http://192.168.239.79:8983/solr/";
    private SolrServer server;
    private Configuration config;

    public SolrSearcher(String solrBaseUrl, Configuration config) {
        HttpSolrServer httpServer = new HttpSolrServer(solrBaseUrl);
        this.config = config;
        this.setupHttpServer(httpServer);
        this.server = httpServer;
    }

    public SolrSearcher(Configuration config) {
        this(config.getConfig("searchServer", DEFAULT_SOLR_URL), config);
    }

    public QueryResponse search(String index, SolrQuery q) {
        return this.search(index, "select", q);
    }

    public SolrQueryResult searchAs(String index, SolrQuery q) {
        return SolrQueryResult.fromResponse(this.search(index, "select", q));
    }

    public QueryResponse search(String index, String handler, SolrQuery q) {
        QueryRequest req = new QueryRequest((SolrParams)q);
        req.setPath("/" + index + "/" + handler);
        try {
            return req.process(this.server);
        }
        catch (SolrServerException e) {
            throw new SearchException(e);
        }
    }

    public KSResult searchKs(HttpUrl searchUrl) throws IOException {
        searchUrl.replaceParam("returnType", "json");
        String rsp = Intf.readHtml4Get(searchUrl.toString(), null, "gbk", 3000, 2);
        if (StringUtils.isBlank((String)rsp)) {
            return new KSResult();
        }
        return (KSResult)JSON.parseObject((String)rsp.trim(), KSResult.class);
    }

    protected void setupHttpServer(HttpSolrServer server) {
        server.setConnectionTimeout(this.config.getIntConfig("http.ConnectTimeout", 5000).intValue());
        server.setSoTimeout(this.config.getIntConfig("http.SoTimeout", 5000).intValue());
        server.setMaxTotalConnections(this.config.getIntConfig("http.ConnectionCount", 100).intValue());
        server.setMaxRetries(this.config.getIntConfig("http.retryTimes", 2).intValue());
        if (this.config.getBooleanConfig("http.useProxy", false).booleanValue()) {
            HttpClient client = server.getHttpClient();
            HttpHost proxy = new HttpHost(this.config.getConfig("http.proxyIp"), this.config.getIntConfig("http.proxyPort").intValue());
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            if (client instanceof DefaultHttpClient) {
                String user = this.config.getConfig("http.proxyUser");
                String pwd = this.config.getConfig("http.proxyPassword");
                if (StringUtils.isNotEmpty((String)user) && StringUtils.isNotEmpty((String)pwd)) {
                    NTCredentials credentials = new NTCredentials(user, pwd, "", "");
                    ((DefaultHttpClient)client).getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)credentials);
                }
            }
        }
    }

    public static void mergeHighLight(QueryResponse rsp, String keyField, List<Map<String, Object>> resultMaps) {
        SolrDocumentList rspList = rsp.getResults();
        if (CollectionUtils.isEmpty((Collection)rspList) || MapUtils.isEmpty((Map)rsp.getHighlighting())) {
            return;
        }
        Object key = null;
        Object result = null;
        boolean useSource = resultMaps == null;
        for (SolrDocument doc : rspList) {
            result = useSource ? doc : new HashMap();
            key = doc.get((Object)keyField);
            Map map = (Map)rsp.getHighlighting().get(key);
            if (MapUtils.isNotEmpty((Map)map)) {
                if (!useSource) {
                    result.putAll(doc);
                }
                for (Map.Entry en : map.entrySet()) {
                    if (((List)en.getValue()).size() == 1) {
                        result.put(en.getKey(), ((List)en.getValue()).get(0));
                        continue;
                    }
                    result.put(en.getKey(), en.getValue());
                }
            }
            if (useSource) continue;
            resultMaps.add((Map<String, Object>)result);
        }
    }

    void close() {
        this.server.shutdown();
    }
}

