/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.query.elements;

import cn.pconline.search.common.query.elements.FieldQuery;
import cn.pconline.search.common.util.QueryUtil;
import org.apache.commons.lang.ArrayUtils;

public class TextQuery
extends FieldQuery {
    private Object[] values;
    private boolean hasValue;

    public TextQuery(String key, Object ... values) {
        super(key);
        this.values = values;
        this.hasValue = ArrayUtils.isNotEmpty((Object[])values);
    }

    public TextQuery(String key, float boost, Object ... values) {
        super(key, boost);
        this.values = values;
        this.hasValue = ArrayUtils.isNotEmpty((Object[])values);
    }

    public boolean isHasValue() {
        return this.hasValue;
    }

    @Override
    protected String getValueExpr() {
        if (this.hasValue) {
            StringBuilder out = new StringBuilder();
            out.append("(");
            this.getMultiStrValue(out, this.values);
            out.append(")");
            return out.toString();
        }
        return "*";
    }

    protected void getMultiStrValue(StringBuilder out, Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            out.append(QueryUtil.escapeQStr(String.valueOf(values[i])));
            if (i >= values.length - 1) continue;
            out.append(" ");
        }
    }
}

