/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.sensitive;

import cn.pconline.search.common.tools.sensitive.AnalyzeSensitiveFilter;
import cn.pconline.search.common.tools.sensitive.SensitiveMatcher;
import cn.pconline.search.common.tools.sensitive.SensitiveWord;
import org.apache.log4j.Logger;

class SensitiveMatcherImpl
implements SensitiveMatcher {
    private static Logger logger = Logger.getLogger(SensitiveMatcherImpl.class);
    private AnalyzeSensitiveFilter.WordMapping mapping;
    private String input;
    private int testLength;
    private int testOffset;
    private int maxInc = -1;
    private SensitiveWord currentWord = null;
    private int currentStart = 0;
    private int currentEnd = 0;

    public SensitiveMatcherImpl(AnalyzeSensitiveFilter.WordMapping mapping, String input) {
        this.mapping = mapping;
        this.input = input;
        this.testLength = mapping.getMinWordLen();
    }

    @Override
    public boolean find() {
        String test;
        if (this.maxInc < 0) {
            if (this.testLength > this.mapping.getMaxWordLen()) {
                this.setEndState();
                return false;
            }
            if (this.testLength > this.input.length()) {
                this.setEndState();
                return false;
            }
            this.testOffset = 0;
            this.maxInc = this.input.length() - this.testLength;
        }
        if ((this.currentWord = this.mapping.hasWord(test = this.input.substring(this.testOffset, this.testLength + this.testOffset))) != null) {
            this.currentStart = this.testOffset;
            this.currentEnd = this.testOffset + this.testLength;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Find a sensitive word [" + test + "] in " + this.input));
            }
            this.addAndcheckTestOffset();
            return true;
        }
        this.addAndcheckTestOffset();
        return this.find();
    }

    private void addAndcheckTestOffset() {
        ++this.testOffset;
        if (this.testOffset > this.maxInc) {
            this.maxInc = -1;
            ++this.testLength;
        }
    }

    @Override
    public int getStart() {
        return this.currentStart;
    }

    @Override
    public int getEnd() {
        return this.currentEnd;
    }

    @Override
    public String getMatch() {
        if (this.currentWord != null) {
            return this.currentWord.getWord();
        }
        return null;
    }

    @Override
    public int getStable() {
        if (this.currentWord != null) {
            return this.currentWord.getStable();
        }
        return -1;
    }

    private void setEndState() {
        this.currentEnd = -1;
        this.currentStart = -1;
        this.currentWord = null;
    }

    public String toString() {
        return "MatcherInfo [input=" + this.input + ", matchWord=" + this.currentWord + ", matchStart=" + this.currentStart + ", matchEnd=" + this.currentEnd + "]";
    }
}

