/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.util;

import cn.pconline.search.common.Configuration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class Config
implements Configuration {
    public static final String CONFIG_FILE = "search.properties";
    private Properties config = new Properties();
    private String configFile;
    private static Config defaultConf;

    public Config(String configFile) {
        this.configFile = configFile;
        InputStream is = null;
        try {
            is = Config.class.getClassLoader().getResourceAsStream(configFile);
            if (is == null) {
                throw new RuntimeException("\u65e0\u6cd5\u5728\u5f53\u524dclasspath\u4e2d\u627e\u5230\u914d\u7f6e\u6587\u4ef6:" + configFile);
            }
            this.config.load(is);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6" + configFile + "\u5931\u8d25!", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    @Override
    public String getConfig(String key, String def) {
        String v = this.config.getProperty(key);
        if (v == null) {
            return def;
        }
        return v;
    }

    @Override
    public Integer getIntConfig(String key, Integer def) {
        String v = this.getConfig(key, null);
        if (v == null) {
            return def;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    @Override
    public Boolean getBooleanConfig(String key, Boolean def) {
        String v = this.getConfig(key, null);
        if (v == null) {
            return def;
        }
        return Boolean.parseBoolean(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Config getDefaultConfig() {
        if (defaultConf != null) return defaultConf;
        Class<Config> clazz = Config.class;
        synchronized (Config.class) {
            if (defaultConf != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return defaultConf;
            }
            defaultConf = new Config(CONFIG_FILE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultConf;
        }
    }

    @Override
    public String getConfig(String key) {
        return this.config.getProperty(key);
    }

    @Override
    public Integer getIntConfig(String key) {
        try {
            return Integer.parseInt(this.getConfig(key));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public Boolean getBooleanConfig(String key) {
        return Boolean.parseBoolean(this.getConfig(key));
    }

    public String toString() {
        return "Config from file[" + this.configFile + "]";
    }

    @Override
    @Deprecated
    public String getConfigNotEmpty(String key) throws IllegalArgumentException {
        return this.require(key);
    }

    @Override
    public String require(String key) throws IllegalArgumentException {
        String v = this.getConfig(key);
        if (StringUtils.isEmpty((String)v)) {
            throw new IllegalArgumentException("config key [" + key + "] is necessary,but it can't found a config value in this configuration!");
        }
        return v;
    }
}

