/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.query.elements;

import cn.pconline.search.common.query.elements.FieldQuery;
import cn.pconline.search.common.util.QueryUtil;

public class Range
extends FieldQuery {
    private Object low;
    private Object up;
    private boolean includeLow;
    private boolean includeUp;

    public Range(String key, Object low, Object up, boolean includeLow, boolean includeUp) {
        super(key);
        this.low = low;
        this.up = up;
        this.includeLow = includeLow;
        this.includeUp = includeUp;
    }

    public Range(String key, Object low, Object up) {
        this(key, low, up, true, true);
    }

    @Override
    protected String getValueExpr() {
        if (this.low == null && this.up == null) {
            return "*";
        }
        StringBuilder out = new StringBuilder();
        if (this.includeLow) {
            out.append("[");
        } else {
            out.append("{");
        }
        if (this.low == null) {
            out.append("*");
        } else {
            out.append(QueryUtil.escapeQStr(String.valueOf(this.low)));
        }
        out.append(" TO ");
        if (this.up == null) {
            out.append("*");
        } else {
            out.append(QueryUtil.escapeQStr(String.valueOf(this.up)));
        }
        if (this.includeUp) {
            out.append("]");
        } else {
            out.append("}");
        }
        return out.toString();
    }
}

