/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.taglib;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class Functions {
    public static final int HIGHEST_SPECIAL = 62;
    public static char[][] specialCharactersRepresentation = new char[63][];

    public static String escape(String input) throws IOException {
        if (input == null) {
            return null;
        }
        StringWriter w = new StringWriter();
        Functions.out(w, true, input);
        return w.toString();
    }

    public static String escapeJs(String input) {
        if (input == null) {
            return null;
        }
        input = input.replace("\\", "\\\\");
        input = input.replace("\"", "\\\"");
        input = input.replace("'", "\\'");
        return input;
    }

    public static void out(Writer w, boolean escapeXml, Object obj) throws IOException {
        if (!escapeXml) {
            if (obj instanceof Reader) {
                int count;
                Reader reader = (Reader)obj;
                char[] buf = new char[4096];
                while ((count = reader.read(buf, 0, 4096)) != -1) {
                    w.write(buf, 0, count);
                }
            } else {
                w.write(obj.toString());
            }
        } else if (obj instanceof Reader) {
            int count;
            Reader reader = (Reader)obj;
            char[] buf = new char[4096];
            while ((count = reader.read(buf, 0, 4096)) != -1) {
                Functions.writeEscapedXml(buf, count, w);
            }
        } else {
            String text = obj.toString();
            Functions.writeEscapedXml(text.toCharArray(), text.length(), w);
        }
    }

    private static void writeEscapedXml(char[] buffer, int length, Writer w) throws IOException {
        int start = 0;
        for (int i = 0; i < length; ++i) {
            char[] escaped;
            char c = buffer[i];
            if (c > '>' || (escaped = specialCharactersRepresentation[c]) == null) continue;
            if (start < i) {
                w.write(buffer, start, i - start);
            }
            w.write(escaped);
            start = i + 1;
        }
        if (start < length) {
            w.write(buffer, start, length - start);
        }
    }

    static {
        Functions.specialCharactersRepresentation[38] = "&amp;".toCharArray();
        Functions.specialCharactersRepresentation[60] = "&lt;".toCharArray();
        Functions.specialCharactersRepresentation[62] = "&gt;".toCharArray();
        Functions.specialCharactersRepresentation[34] = "&#034;".toCharArray();
        Functions.specialCharactersRepresentation[39] = "&#039;".toCharArray();
    }
}

