/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.util;

import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PagerUtil {
    public static String replace(String newValue, String param, String query) {
        if (query != null) {
            query = query.replaceAll("&*" + param + "=[^&]*", "&" + param + "=" + newValue);
        }
        return query;
    }

    public static String getQueryString(Map map) throws Exception {
        Set ks = map.keySet();
        String queryStr = "";
        for (String key : ks) {
            String[] val = (String[])map.get(key);
            for (int i = 0; val != null && i < val.length; ++i) {
                queryStr = queryStr + key + "=" + URLEncoder.encode(val[i], "GBK") + "&";
            }
        }
        return queryStr.replaceAll("&*$", "");
    }

    public static String getQueryStringNoEN(Map map) throws Exception {
        Set ks = map.keySet();
        String queryStr = "";
        for (String key : ks) {
            String[] val = (String[])map.get(key);
            for (int i = 0; val != null && i < val.length; ++i) {
                queryStr = queryStr + key + "=" + val[i] + "&";
            }
        }
        return queryStr.replaceAll("&*$", "");
    }

    public static String delQueryStringParam(String queryStr, String param) {
        if (queryStr != null) {
            String _queryStr = queryStr.replaceAll("&*" + param + "=[^&]*$", "");
            queryStr = _queryStr.equals(queryStr) ? queryStr.replaceAll(param + "=[^&]*&*", "") : _queryStr;
            return queryStr;
        }
        return "";
    }

    public static String delQueryString(String queryStr, String param) {
        if (queryStr != null) {
            String _queryStr = queryStr.replaceAll(param, "");
            return _queryStr;
        }
        return "";
    }

    public static String getCurrentPage(HttpServletRequest request) {
        String currentPage = "http://" + request.getServerName() + (request.getServerPort() == 80 ? "" : ":" + request.getServerPort()) + request.getRequestURI();
        return currentPage;
    }

    public static String getPagerString(HttpServletRequest request, int total, int pageSize, int pageNo, String pageNoString, String className) throws Exception {
        int startPage;
        --pageNo;
        int lastCount = (total - 1) / pageSize;
        if (pageNoString == null) {
            pageNoString = "pageNo";
        }
        className = className == null ? "" : " class=\"" + className + "\"";
        String queryStr = PagerUtil.getQueryString(request.getParameterMap());
        String currentPage = "http://" + request.getServerName() + (request.getServerPort() == 80 ? "" : ":" + request.getServerPort()) + request.getRequestURI();
        String noPageNo = PagerUtil.delQueryStringParam(queryStr, pageNoString);
        String aUrl = currentPage = currentPage + "?" + (noPageNo.equals("") ? "" : noPageNo + "&");
        String pagerString = "<div" + className + ">\u5171" + (lastCount + 1) + "\u9875&nbsp;";
        if (pageNo > 0) {
            pagerString = pagerString + " [<A HREF=\"" + aUrl + "\">\u9996\u9875</A>]";
            pagerString = pagerString + "<A HREF=\"" + aUrl + pageNoString + "=" + pageNo + "\">\u4e0a\u4e00\u9875</A>";
        }
        int i = 0;
        int n = lastCount - pageNo < 4 ? (lastCount - 9 > 0 ? lastCount - 9 : 0) : (startPage = pageNo - 5 > 0 ? pageNo - 5 : 0);
        while (i < 10) {
            if (pageNo == i + startPage) {
                pagerString = pagerString + " <strong>" + (i + startPage + 1) + "</strong>";
            } else {
                if (i + startPage > lastCount) break;
                pagerString = pagerString + " [<A HREF=\"" + aUrl + pageNoString + "=" + (i + startPage + 1) + "\">" + (i + startPage + 1) + "</A>]";
            }
            ++i;
        }
        if (pageNo < lastCount) {
            pagerString = pagerString + "<A HREF=\"" + aUrl + pageNoString + "=" + (pageNo + 2) + "\">\u4e0b\u4e00\u9875</A>";
            pagerString = pagerString + "[<A HREF=\"" + aUrl + pageNoString + "=" + (lastCount + 1) + "\">\u5c3e\u9875</A>]";
        }
        pagerString = pagerString + "</div>";
        return pagerString;
    }
}

