/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.util;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class QueryUtil {
    private static Map<Pattern, String> escapeMap = new LinkedHashMap<Pattern, String>();

    public static String toDismaxQuery(String keyword, Map<String, Float> boostMap) {
        StringBuilder builder = new StringBuilder();
        builder.append("_query_:\"{!edismax qf='");
        for (Map.Entry<String, Float> en : boostMap.entrySet()) {
            builder.append(en.getKey()).append("^").append(new BigDecimal(en.getValue().floatValue()).toPlainString()).append(" ");
        }
        builder.append("'}").append(QueryUtil.escapeQStr(keyword));
        return builder.toString();
    }

    private static void addToEscapeMap(String key, String value) {
        escapeMap.put(Pattern.compile(key, 16), Matcher.quoteReplacement(value));
    }

    public static String escapeQStr(String query) {
        if (StringUtils.isEmpty((String)query)) {
            return query;
        }
        query = query.trim();
        for (Map.Entry<Pattern, String> e : escapeMap.entrySet()) {
            query = e.getKey().matcher(query).replaceAll(e.getValue());
        }
        return query;
    }

    public static boolean shouldUsePharse(String input) {
        if (StringUtils.isBlank((String)input)) {
            return false;
        }
        input = input.trim();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isSpaceChar(input.charAt(i)) || Character.isWhitespace(input.charAt(i))) {
                return false;
            }
            if (Character.isDigit(input.charAt(i)) || Character.isUpperCase(c) || Character.isLowerCase(c) || input.charAt(i) == '_' || input.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }

    public static String subQueryString(String q, int max) {
        if (q.length() <= max) {
            return q;
        }
        int blen = QueryUtil.getStringBLen(q);
        if (blen <= (max *= 2)) {
            return q;
        }
        q = q.trim();
        StringBuilder out = new StringBuilder(q);
        do {
            char last = out.charAt(out.length() - 1);
            out.delete(out.length() - 1, out.length());
            Character.UnicodeBlock ub = Character.UnicodeBlock.of(last);
            if (ub == Character.UnicodeBlock.ARABIC) {
                while (out.length() != 0 && (ub = Character.UnicodeBlock.of(out.charAt(out.length() - 1))) == Character.UnicodeBlock.ARABIC) {
                    out.delete(out.length() - 1, out.length());
                }
            } else {
                if (!QueryUtil.isLetter(last)) continue;
                while (out.length() != 0 && QueryUtil.isLetter(out.charAt(out.length() - 1))) {
                    out.delete(out.length() - 1, out.length());
                }
            }
        } while (out.length() > 0 && QueryUtil.getStringBLen(out.toString()) > max);
        if (out.length() == 0) {
            return q.substring(0, max);
        }
        return out.toString();
    }

    private static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static int getStringBLen(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return 0;
        }
        int len = 0;
        Character.UnicodeBlock ub = null;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            ub = Character.UnicodeBlock.of(c);
            if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A) {
                len += 2;
                continue;
            }
            ++len;
        }
        return len;
    }

    static {
        QueryUtil.addToEscapeMap("\\", "\\\\");
        QueryUtil.addToEscapeMap("\"", "\\\"");
        QueryUtil.addToEscapeMap("/", "\\/");
        QueryUtil.addToEscapeMap("?", "\\?");
        QueryUtil.addToEscapeMap("*", "\\*");
        QueryUtil.addToEscapeMap(":", "\\:");
        QueryUtil.addToEscapeMap("~", "\\~");
        QueryUtil.addToEscapeMap("+", "\\+");
        QueryUtil.addToEscapeMap("-", "\\-");
        QueryUtil.addToEscapeMap("^", "\\^");
        QueryUtil.addToEscapeMap("(", "\\(");
        QueryUtil.addToEscapeMap(")", "\\)");
        QueryUtil.addToEscapeMap("[", "\\[");
        QueryUtil.addToEscapeMap("]", "\\]");
        QueryUtil.addToEscapeMap("{", "\\{");
        QueryUtil.addToEscapeMap("}", "\\}");
        QueryUtil.addToEscapeMap("OR", "\\OR");
        QueryUtil.addToEscapeMap("AND", "\\AND");
        QueryUtil.addToEscapeMap("NOT", "\\NOT");
    }
}

