package cn.pconline.search.common.log;

import org.apache.commons.io.IOUtils;

import cn.pconline.search.common.Configuration;

/**
 * 搜索记录日志记录器
 * <p>
 * 在旧快搜的搜索日志代码上进行了优化和相关结构优化<b>(此类与Java中的日志功能无任何关系)</b>
 * </p>
 * 
 * @author zengjie
 * @since 2013-9-23
 * @see LogIO
 * @see LogSaveThread
 */
public class SearchLogger
{

    private LogIO logIO;

    private LogSaveThread saveThread;

    protected Configuration config;

    public SearchLogger(Configuration config)
    {
        this.config = config;
        this.logIO = new LogIO(config.getConfig("logSaveFloder", null));
        this.saveThread = new LogSaveThread(logIO, config);
        this.saveThread.start();
    }

    public void logSearch(String app, String key, int result)
    {
        try
        {
            if (key == null || key.trim().equals(""))
            {
                return;
            }
            if (app == null || app.trim().equals(""))
            {
                return;
            }
            if (key.length() > 20) return;
            logIO.writeLog(new SearchLog(app, key, result));
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
    }

    /**
     * 关闭日志的记录或者中止记录入库
     */
    public void close()
    {
        IOUtils.closeQuietly(logIO);
        saveThread.interrupt();
        try
        {
            saveThread.join();
        }
        catch (InterruptedException e)
        {
        }
    }
}
