package cn.pconline.search.common.query;

/**
 * 操作符
 * 
 * @author zengjie
 * @since 2013-9-24
 * @see
 */
public enum Operator
{
    MUST
    {

        public String toString()
        {
            return "+";
        }

        @Override
        public String toConnectString()
        {
            return "AND";
        }
    },
    SHOULD
    {

        public String toString()
        {
            return "";
        }

        @Override
        public String toConnectString()
        {
            return "OR";
        }
    },
    MUST_NOT
    {

        public String toString()
        {
            return "-";
        }

        @Override
        public String toConnectString()
        {
            return "AND NOT";
        }
    };

    /**
     * 返回操作符连接两个条件时使用的字符
     * 
     * @return
     */
    public abstract String toConnectString();

}
