package cn.pconline.search.common.query.elements;

import org.apache.commons.lang.ArrayUtils;

import cn.pconline.search.common.util.QueryUtil;

/**
 * 普通文本查询
 * 
 * @author zengjie
 * @since 2013-11-29
 * @see
 */
public class TextQuery extends FieldQuery
{

    private Object[] values;

    private boolean hasValue;

    public TextQuery(String key, Object... values)
    {
        super(key);
        this.values = values;
        hasValue = ArrayUtils.isNotEmpty(values);
    }

    public TextQuery(String key, float boost, Object... values)
    {
        super(key, boost);
        this.values = values;
        hasValue = ArrayUtils.isNotEmpty(values);
    }

    public boolean isHasValue()
    {
        return hasValue;
    }

    @Override
    protected String getValueExpr()
    {
        if (hasValue)
        {
            StringBuilder out = new StringBuilder();
            out.append("(");
            getMultiStrValue(out, values);
            out.append(")");
            return out.toString();
        }
        return "*";
    }

    /**
     * 对有值的情况进行拼接
     * 
     * @param out
     * @param values
     */
    protected void getMultiStrValue(StringBuilder out, Object[] values)
    {
        for (int i = 0; i < values.length; i++)
        {
            out.append(QueryUtil.escapeQStr(String.valueOf(values[i])));
            if (i < values.length - 1)
            {
                out.append(" ");
            }
        }
    }

}
