package cn.pconline.search.common.query.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import cn.pconline.search.common.query.Operator;

/**
 * Boolean查询树
 * 
 * @author zengjie
 * @since 2013-11-29
 * @see
 */
public class Tree extends Element implements
        Iterable<cn.pconline.search.common.query.elements.Tree.QueryNode>
{

    private List<QueryNode> elements;

    public Tree()
    {
        super();
    }

    public Tree(float boost)
    {
        super(boost);
    }

    @SuppressWarnings("unchecked")
    public Iterator<QueryNode> iterator()
    {
        List<QueryNode> list = getElements(false);
        if (list == null)
        {
            return Collections.EMPTY_LIST.iterator();
        }
        return list.iterator();
    }

    /**
     * 添加查询节点
     * 
     * @param element
     */
    public void addNode(QueryNode element)
    {
        getElements(true).add(element);
    }

    /**
     * 添加查询节点
     * 
     * @param element
     */
    public void addNode(Element element)
    {
        getElements(true).add(new QueryNode(element));
    }

    /**
     * 添加查询节点
     * 
     * @param element
     */
    public void addNode(Element element, Operator operator)
    {
        getElements(true).add(new QueryNode(element, operator));
    }

    public boolean removeElement(QueryNode element)
    {
        List<QueryNode> list = getElements(false);
        if (list != null)
        {
            return list.remove(element);
        }
        return false;
    }

    public boolean isEmpty()
    {
        return CollectionUtils.isNotEmpty(getElements(false));
    }

    /**
     * 清空节点
     */
    public void clear()
    {
        if (getElements(false) != null)
        {
            getElements(false).clear();
        }
    }

    private List<QueryNode> getElements(boolean init)
    {
        if (init && elements == null)
        {
            return elements = new LinkedList<QueryNode>();
        }
        return elements;
    }

    @Override
    public String toString()
    {
        List<QueryNode> els = getElements(false);
        String boost = getBoostString();
        if (CollectionUtils.isEmpty(els))
        {
            String ret = "*:*";
            return ret + (boost == null ? "" : ("^" + boost));
        }
        StringBuilder out = new StringBuilder();
        out.append("(");
        if (els.size() == 1)
        {
            out.append(els.get(0));
        }
        else
        {
            Iterator<QueryNode> nodes = iterator();
            List<QueryNode> require = new ArrayList<Tree.QueryNode>();
            List<QueryNode> should = new ArrayList<Tree.QueryNode>();
            QueryNode node = null;
            while (nodes.hasNext())
            {
                node = nodes.next();
                if (node.operator == Operator.SHOULD)
                {
                    should.add(node);
                }
                else
                {
                    require.add(node);
                }
            }
            int index = 0;
            if (require.size() > 0)
            {
                for (QueryNode n : require)
                {
                    index++;
                    if (index == 1)
                    {
                        if (n.operator == Operator.MUST_NOT)
                        {
                            out.append("NOT ");
                        }
                    }
                    else
                    {
                        out.append(" ").append(n.operator.toConnectString())
                                .append(" ");
                    }
                    out.append(n.element);
                }
                if (should.size() > 0)
                {
                    out.append(" AND ");
                    out.append(FieldQuery.newMatchFieldQ("*"));
                }
            }
            if (should.size() > 0)
            {
                index = 0;
                for (QueryNode n : should)
                {
                    index++;
                    if (index == 1)
                    {
                        if (require.size() > 0)
                        {
                            out.append(" ")
                                    .append(n.operator.toConnectString())
                                    .append(" ");
                        }
                    }
                    else
                    {
                        out.append(" ").append(n.operator.toConnectString())
                                .append(" ");
                    }
                    out.append(n.element);
                }
            }
        }
        out.append(")");
        if (boost != null)
        {
            out.append("^").append(boost);
        }
        return out.toString();
    }

    public static final class QueryNode
    {

        public Element element;

        public Operator operator = Operator.MUST;

        public QueryNode(Element element)
        {
            this.element = element;
        }

        public QueryNode(Element element, Operator operator)
        {
            super();
            this.element = element;
            this.operator = operator;
        }

        public String toString()
        {
            return operator.toString() + element;
        }
    }

}
