package cn.pconline.search.common.taglib;

import java.io.IOException;

import javax.servlet.jsp.JspException;

public class IfOutTag extends BaseTag
{

    private static final long serialVersionUID = 7148081898420021463L;

    private Object trueOut;

    private Object falseOut;

    private boolean test;

    private boolean escapeXml = true;

    @Override
    public int doStartTag() throws JspException
    {
        try
        {
            Object out = test ? trueOut : falseOut;
            if (out != null)
            {
                Functions.out(pageContext.getOut(), escapeXml, out);
            }
        }
        catch (IOException e)
        {
            throw new JspException(e);
        }
        return SKIP_BODY;
    }

    public void setTrueOut(String trueOut)
    {
        this.trueOut = trueOut;
    }

    public void setFalseOut(String falseOut)
    {
        this.falseOut = falseOut;
    }

    public void setTest(boolean test)
    {
        this.test = test;
    }

    public void setEscapeXml(boolean escapeXml)
    {
        this.escapeXml = escapeXml;
    }

}
