/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.log;

import cn.pconline.search.common.log.GroupCounter;
import cn.pconline.search.common.log.LogIO;
import cn.pconline.search.common.log.LogIterator;
import cn.pconline.search.common.log.SearchLog;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SearchLogHelper {
    public static List<GroupCounter.Item> getTop(LogIO logIO, int top, Map<SearchLog, Integer> keyOccurMap) throws Exception {
        GroupCounter groupCounter = SearchLogHelper.getGroupCounter(logIO, keyOccurMap);
        if (groupCounter == null) {
            return Collections.EMPTY_LIST;
        }
        return groupCounter.getTop(top);
    }

    public static GroupCounter getGroupCounter(LogIO logIO, Map<SearchLog, Integer> keyOccurMap) throws Exception {
        LogIterator iterator = logIO.getYesterdayLogs();
        GroupCounter groupCounter = null;
        if (iterator != null) {
            groupCounter = new GroupCounter();
            while (iterator.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                SearchLog searchLog = iterator.next();
                Integer result = keyOccurMap.get(searchLog);
                if (result == null) {
                    keyOccurMap.put(searchLog, searchLog.getRetCount());
                } else if (searchLog.getRetCount() >= 0) {
                    keyOccurMap.put(searchLog, searchLog.getRetCount());
                }
                groupCounter.add(searchLog);
            }
            iterator.close();
        }
        return groupCounter;
    }
}

