/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.query;

import cn.pconline.search.common.query.FunctionQuery;
import cn.pconline.search.common.query.Q;
import cn.pconline.search.common.query.elements.Element;
import org.apache.commons.lang.ArrayUtils;
import org.apache.solr.client.solrj.SolrQuery;

public class SolrQueryExt
extends SolrQuery {
    private static final long serialVersionUID = 2713307384547708781L;

    public SolrQueryExt() {
    }

    public SolrQueryExt(String q) {
        super(q);
    }

    public SolrQueryExt setHighLightAlternateField(String ... fields) {
        if (ArrayUtils.isNotEmpty((Object[])fields)) {
            for (String field : fields) {
                this.set(this.fpname(field, "hl.alternateField"), new String[]{field});
            }
        }
        return this;
    }

    public SolrQueryExt setHighLightAlternateFieldLength(String field, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length");
        }
        this.set(this.fpname(field, "hl.maxAlternateFieldLength"), length);
        return this;
    }

    public SolrQueryExt addFunctionQuerySort(FunctionQuery q, SolrQuery.ORDER order) {
        this.addSort(new SolrQuery.SortClause(q.toString(), order));
        return this;
    }

    @Deprecated
    public SolrQueryExt setQuery(Q query) {
        this.set("q", new String[]{query.toString()});
        return this;
    }

    public SolrQueryExt setQuery(Element query) {
        this.set("q", new String[]{query.toString()});
        return this;
    }

    public SolrQueryExt setUseSynonym(boolean useSynonym) {
        this.set("useSynonym", useSynonym);
        return this;
    }

    public SolrQueryExt addIncludeAdIds(String ... ids) {
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return this;
        }
        String inludes = this.get("elevateIncludes");
        StringBuilder sb = null;
        sb = inludes != null ? new StringBuilder() : new StringBuilder(",");
        for (String id : ids) {
            sb.append(id).append(",");
        }
        sb.delete(sb.length() - 1, sb.length());
        this.set("elevateIncludes", new String[]{sb.toString()});
        return this;
    }

    public SolrQueryExt setDefaultOperator(Ope operator) {
        this.set("q.op", new String[]{operator.toString()});
        return this;
    }

    public static enum Ope {
        AND,
        OR;

    }
}

