/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.semantic2;

import cn.pconline.search.common.tools.semantic2.DictWord;
import cn.pconline.search.common.tools.semantic2.DictWordIterator;
import cn.pconline.search.common.tools.semantic2.SemanticAnalyzer;
import cn.pconline.search.common.tools.semantic2.SemanticResult;
import cn.pconline.search.common.tools.semantic2.SemanticWord;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractAnalyzer
implements SemanticAnalyzer {
    private int maxWord = 0;
    private int minWord = Integer.MAX_VALUE;
    private Map<String, SemanticWord> wordMap = new HashMap<String, SemanticWord>();

    @Override
    public void loadDict(DictWordIterator dict) {
        DictWord word = null;
        while ((word = dict.next()) != null) {
            this.maxWord = Math.max(this.maxWord, word.getWord().length());
            this.minWord = Math.min(this.minWord, word.getWord().length());
            this.loadWordIntoMap(word, this.wordMap);
        }
        dict.close();
    }

    protected abstract void loadWordIntoMap(DictWord var1, Map<String, SemanticWord> var2);

    @Override
    public SemanticResult analyze(String input) {
        if (this.wordMap.isEmpty()) {
            return null;
        }
        if (StringUtils.isBlank((String)input)) {
            return null;
        }
        if ((input = input.trim().toLowerCase()).length() < this.minWord) {
            return null;
        }
        LinkedHashMap<String, SemanticWord> retMap = new LinkedHashMap<String, SemanticWord>();
        char[] temp = new char[this.maxWord];
        String[] sequences = input.split("\\s+");
        StringBuilder otherQuery = new StringBuilder();
        for (String sequence : sequences) {
            if (sequence.length() < this.minWord) continue;
            CharBuffer buffer = CharBuffer.wrap(sequence.toCharArray());
            buffer.position(0).limit(buffer.capacity());
            while (buffer.hasRemaining()) {
                int toGet = Math.min(temp.length, buffer.remaining());
                buffer.get(temp, 0, toGet);
                boolean find = false;
                for (int flag = toGet; flag >= this.minWord; --flag) {
                    String key = new String(temp, 0, flag);
                    SemanticWord word = this.wordMap.get(key);
                    if (word == null) continue;
                    if (retMap.containsKey(key)) {
                        SemanticWord retW = (SemanticWord)retMap.get(key);
                        retW.setBoost(retW.getBoost() + word.getBoost());
                    } else {
                        retMap.put(key, word.getCopy());
                    }
                    buffer.position(buffer.position() - (toGet - flag));
                    otherQuery.append(" ");
                    toGet = flag;
                    find = true;
                }
                if (find) continue;
                buffer.position(buffer.position() - toGet);
                otherQuery.append(buffer.get());
            }
            otherQuery.append(" ");
        }
        return new SemanticResult(new ArrayList<SemanticWord>(retMap.values()), otherQuery.toString());
    }
}

