package cn.pconline.search.common.taglib;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * 标签父类
 * 
 * @author zengjie
 * @since 2013-9-17
 * @see
 */
public abstract class BaseTag extends TagSupport
{

    private static final long serialVersionUID = 8185712256077123907L;

    protected void writeToOut(Object obj) throws JspException
    {
        try
        {
            this.pageContext.getOut().write(
                    obj == null ? "null" : obj.toString());
        }
        catch (IOException e)
        {
            throw new JspException(e);
        }
    }

    /**
     * 获取Integer标签属性
     * 
     * @param key
     * @param defaultValue
     * @return
     */
    protected Integer getIntAttribute(String key, Integer defaultValue)
    {
        Object value = getValue(key);
        if (value == null)
        {
            return defaultValue;
        }
        if (value instanceof Integer)
        {
            return (Integer) value;
        }
        try
        {
            return Integer.parseInt(String.valueOf(value));
        }
        catch (NumberFormatException e)
        {
            return defaultValue;
        }
    }

    /**
     * 获取字符串属性
     * 
     * @param key
     * @param def
     * @return
     */
    protected String getStringAttribute(String key, String def)
    {
        Object value = getValue(key);
        if (value == null)
        {
            return def;
        }
        if (value instanceof String)
        {
            return (String) value;
        }
        return value.toString();
    }

}
