package cn.pconline.search.common.util;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

import org.apache.commons.lang.StringUtils;

/**
 * 
 * <p>
 * Title:Cache
 * </p>
 * <p>
 * Description:封装了同步操作的缓存
 * </p>
 * 
 * @author kelly 2009-6-24 jiajiam2000@hotmail.com
 */
public class Cache<T>
{

    private Map<String, T> lhm;

    private int maxSize;

    /**
     * 缓存版本号
     */
    private AtomicLong version = new AtomicLong(0);

    public void setVersion(long version)
    {
        this.version.set(version);
    }

    public long getVersion()
    {
        return version.get();
    }

    public Cache(int size)
    {
        lhm = new LRULinkedHashMap<String, T>(size);
        this.maxSize = size;
    }

    public void clear()
    {
        lhm.clear();
    }

    public void add(String key, T value)
    {
        if (StringUtils.isNotBlank(key) && value != null)
        {
            lhm.put(key, value);
        }
    }

    public Object get(String key)
    {
        return lhm.get(key);

    }

    public int size()
    {
        return lhm.size();
    }

    public int getMaxSize()
    {
        return maxSize;
    }
}
