package cn.pconline.search.common.util;

import java.util.Calendar;
import java.util.Date;

public class DateUtil {
	/**
	 * 得到昨天日期
	 * 
	 * @return
	 */
	public static Date getYesterday() {
		Calendar c = Calendar.getInstance();
		c.add(Calendar.DATE, -1);
		return c.getTime();
	}

	/*****************************************************************************
	 * 这个星期的星期一的日期
	 * 
	 * @return
	 */
	public static Date getFirstDayOfThisWeek() {
		Calendar c = Calendar.getInstance();
		int todayOfWeek = c.get(Calendar.DAY_OF_WEEK) - 1;// 今日星期几
		int less = todayOfWeek - 1;// 今天到星期一还差多少天
		c.set(Calendar.DATE, c.get(Calendar.DATE) - less);// 设置星期一的日期
		return c.getTime();
	}

	/*****************************************************************************
	 * 这个星期的星期日的日期
	 * 
	 * @return
	 */
	public static Date getLastDayOfThisWeek() {
		Calendar c = Calendar.getInstance();
		int todayOfWeek = c.get(Calendar.DAY_OF_WEEK) - 1;// 今日星期几
		int more = 7 - todayOfWeek;// 今天到星期日还差多少天
		c.set(Calendar.DATE, c.get(Calendar.DATE) + more);// 设置星期一的日期
		return c.getTime();
	}

	/*****************************************************************************
	 * 这个月的第一天日期
	 * 
	 * @return
	 */
	public static Date getFirstDayOfThisMonth() {
		Calendar c = Calendar.getInstance();
		c.set(Calendar.DATE, Calendar.getInstance().getMinimum(Calendar.DATE));
		return c.getTime();
	}

	/*****************************************************************************
	 * 这个月的最后一天日期
	 * 
	 * @return
	 */
	public static Date getLastDayOfThisMonth() {
		Calendar c = Calendar.getInstance();
		c.set(Calendar.DATE, Calendar.getInstance().getMaximum(Calendar.DATE));
		return c.getTime();
	}

	/**
	 * 今年的第一天日期
	 * 
	 * @return
	 */
	public static Date getFirstDayOfThisYear() {
		Calendar c = Calendar.getInstance();
		c.set(Calendar.DATE, 1);
		c.set(Calendar.MONTH, 0);
		return c.getTime();
	}

	/**
	 * 今年的最后一天日期
	 * 
	 * @return
	 */
	public static Date getLastDayOfThisYear() {
		Calendar c = Calendar.getInstance();
		c.set(Calendar.MONTH, 11);
		c.set(Calendar.DATE, 31);
		return c.getTime();
	}
}
