/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.log;

import cn.pconline.search.common.log.LogIterator;
import cn.pconline.search.common.log.SearchLog;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class LogIO
implements Closeable {
    private static final String LOG_FILE_PREFIX = "SearchLog.";
    private static final Charset CHARSET = Charset.forName("GBK");
    private Map<String, OutWrapper> outMap = new ConcurrentHashMap<String, OutWrapper>();
    private Object writeLock = new Object();
    private String logFileFloder;

    public LogIO(String logFileFloder) {
        this.logFileFloder = logFileFloder;
    }

    public LogIO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLog(SearchLog log) throws IOException {
        OutWrapper wrapper = null;
        try {
            wrapper = this.getOut(log);
            byte[] content = log.getKey().getBytes(CHARSET);
            byte[] app = log.getApp().getBytes(CHARSET);
            ByteBuffer buffer = ByteBuffer.allocate(content.length + 1 + app.length + 1 + 4 + 8);
            buffer.put((byte)app.length);
            buffer.put(app);
            buffer.put((byte)content.length);
            buffer.put(content);
            buffer.putInt(log.getRetCount());
            buffer.putLong(log.getSearchTime().getTime());
            Object object = this.writeLock;
            synchronized (object) {
                wrapper.out.write(buffer.array());
            }
        }
        finally {
            this.releaseOut(wrapper);
        }
    }

    public LogIterator getYesterdayLogs() throws IOException {
        return this.getIterator(LogIO.getYesterday());
    }

    public LogIterator getIterator(Date date) throws IOException {
        File f = null;
        f = StringUtils.isNotEmpty((String)this.logFileFloder) ? new File(this.logFileFloder, LOG_FILE_PREFIX + LogIO.getFileKey(date)) : new File(LOG_FILE_PREFIX + LogIO.getFileKey(date));
        if (f.exists() && f.isFile() && f.length() > 0L) {
            final FileInputStream in = new FileInputStream(f);
            return new LogIterator(in, new Iterator<SearchLog>(){
                private SearchLog log;
                private boolean EOF = false;

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public SearchLog next() {
                    if (this.EOF) {
                        throw new NoSuchElementException();
                    }
                    if (this.log == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    SearchLog ret = this.log;
                    this.log = null;
                    return ret;
                }

                @Override
                public boolean hasNext() {
                    if (this.EOF) {
                        return false;
                    }
                    try {
                        this.log = LogIO.this.read(in);
                        if (this.log == null) {
                            this.EOF = true;
                            return false;
                        }
                        return true;
                    }
                    catch (IOException e) {
                        this.EOF = true;
                        return false;
                    }
                }
            });
        }
        return null;
    }

    private SearchLog read(InputStream in) throws IOException {
        SearchLog log = new SearchLog();
        if (in.available() <= 0) {
            return null;
        }
        byte appLength = (byte)in.read();
        if (appLength <= 0) {
            return null;
        }
        byte[] app = new byte[appLength];
        if (in.available() <= 0 || in.read(app) < appLength) {
            return null;
        }
        log.setApp(new String(app, CHARSET));
        if (in.available() <= 0) {
            return null;
        }
        byte contentLength = (byte)in.read();
        if (contentLength <= 0) {
            return null;
        }
        byte[] content = new byte[contentLength];
        if (in.available() <= 0 || in.read(content) < contentLength) {
            return null;
        }
        log.setKey(new String(content, CHARSET));
        byte[] arr = new byte[12];
        if (in.available() <= 0 || in.read(arr) < arr.length) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(arr);
        log.setRetCount(buffer.getInt());
        log.setSearchTime(new Date(buffer.getLong()));
        return log;
    }

    private static Date getToday() {
        Calendar c = Calendar.getInstance();
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getYesterday() {
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static String getFileKey(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String key = sdf.format(date);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutWrapper getOut(SearchLog log) throws IOException {
        String key = LogIO.getFileKey(log.getSearchTime());
        OutWrapper wrapper = this.outMap.get(key);
        if (wrapper == null) {
            Map<String, OutWrapper> map = this.outMap;
            synchronized (map) {
                wrapper = this.outMap.get(key);
                if (wrapper == null) {
                    String yesterdayKey = LogIO.getFileKey(LogIO.getYesterday());
                    OutWrapper yesterday = this.outMap.get(yesterdayKey);
                    if (yesterday != null) {
                        IOUtils.closeQuietly((OutputStream)yesterday.out);
                        this.outMap.remove(yesterdayKey);
                    }
                    wrapper = new OutWrapper();
                    wrapper.file = StringUtils.isEmpty((String)this.logFileFloder) ? new File(LOG_FILE_PREFIX + key) : new File(this.logFileFloder, LOG_FILE_PREFIX + key);
                    this.createFolder(wrapper.file.getParentFile());
                    wrapper.out = new FileOutputStream(wrapper.file, true);
                    wrapper.out = new BufferedOutputStream(wrapper.out, 524288);
                    wrapper.dateFor = LogIO.getToday();
                    this.outMap.put(key, wrapper);
                }
            }
        }
        wrapper.refCount.incrementAndGet();
        return wrapper;
    }

    private void createFolder(File file) throws IOException {
        if (file == null || file.exists()) {
            return;
        }
        this.createFolder(file.getParentFile());
        if (!file.mkdir()) {
            throw new IOException("create folder [" + file + "] fail");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseOut(OutWrapper wrapper) {
        if (wrapper == null) {
            return;
        }
        wrapper.refCount.decrementAndGet();
        if (wrapper.refCount.get() == 0L && wrapper.dateFor.getTime() < LogIO.getToday().getTime()) {
            Map<String, OutWrapper> map = this.outMap;
            synchronized (map) {
                IOUtils.closeQuietly((OutputStream)wrapper.out);
                this.outMap.remove(LogIO.getFileKey(wrapper.dateFor));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Map<String, OutWrapper> map = this.outMap;
        synchronized (map) {
            Iterator<Map.Entry<String, OutWrapper>> it = this.outMap.entrySet().iterator();
            while (it.hasNext()) {
                IOUtils.closeQuietly((OutputStream)it.next().getValue().out);
                it.remove();
            }
        }
    }

    private class OutWrapper {
        private Date dateFor;
        private File file;
        private OutputStream out;
        private AtomicLong refCount = new AtomicLong(0L);

        private OutWrapper() {
        }
    }
}

