/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.query;

import cn.pconline.r.client.RequestCallback;
import cn.pconline.r.client.ResponseExtractor;
import cn.pconline.r.client.SimpleHttpTemplate;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;

public class RHttpSolrServer
extends HttpSolrServer {
    private static final long serialVersionUID = -1101254915951168009L;
    private SimpleHttpTemplate httpTemplate;

    public RHttpSolrServer(String baseURL, SimpleHttpTemplate httpTemplate) {
        super(baseURL);
        this.httpTemplate = httpTemplate;
    }

    public NamedList<Object> request(SolrRequest request, final ResponseParser processor) throws SolrServerException, IOException {
        if (this.httpTemplate == null) {
            return super.request(request, processor);
        }
        try {
            ResponseParser parser;
            SolrParams sourceParams = request.getParams();
            final Collection streams = this.requestWriter.getContentStreams(request);
            String path = this.requestWriter.getPath(request);
            if (path == null || !path.startsWith("/")) {
                path = "/select";
            }
            if ((parser = request.getResponseParser()) == null) {
                parser = this.parser;
            }
            ModifiableSolrParams wparams = new ModifiableSolrParams(sourceParams);
            if (parser != null) {
                wparams.set("wt", new String[]{parser.getWriterType()});
                wparams.set("version", new String[]{parser.getVersion()});
            }
            if (this.invariantParams != null) {
                wparams.add((SolrParams)this.invariantParams);
            }
            ModifiableSolrParams params = wparams;
            String requestUrl = this.baseUrl + path;
            if (SolrRequest.METHOD.GET == request.getMethod()) {
                if (streams != null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "GET can't send streams!");
                }
                requestUrl = requestUrl + ClientUtils.toQueryString((SolrParams)params, (boolean)false);
            }
            final String url = requestUrl;
            ResponseExtractor<NamedList<Object>> extractor = new ResponseExtractor<NamedList<Object>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public NamedList<Object> extractData(HttpResponse response) throws IOException {
                    boolean shouldClose = true;
                    InputStream respBody = null;
                    int httpStatus = response.getStatusLine().getStatusCode();
                    switch (httpStatus) {
                        case 200: 
                        case 400: 
                        case 409: {
                            break;
                        }
                        case 301: 
                        case 302: {
                            break;
                        }
                        default: {
                            throw new SolrException(SolrException.ErrorCode.getErrorCode((int)httpStatus), "Server at " + RHttpSolrServer.this.getBaseURL() + " returned non ok status:" + httpStatus + ", message:" + response.getStatusLine().getReasonPhrase());
                        }
                    }
                    respBody = response.getEntity().getContent();
                    if (processor == null) {
                        NamedList rsp = new NamedList();
                        rsp.add("stream", (Object)respBody);
                        shouldClose = false;
                        NamedList namedList = rsp;
                        return namedList;
                    }
                    String charset = EntityUtils.getContentCharSet((HttpEntity)response.getEntity());
                    NamedList rsp = processor.processResponse(respBody, charset);
                    if (httpStatus != 200) {
                        String reason = null;
                        try {
                            NamedList err = (NamedList)rsp.get("error");
                            if (err != null) {
                                reason = (String)err.get("msg");
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        if (reason == null) {
                            StringBuilder msg = new StringBuilder();
                            msg.append(response.getStatusLine().getReasonPhrase());
                            msg.append("\n\n");
                            msg.append("request: " + url);
                            reason = URLDecoder.decode(msg.toString(), "UTF-8");
                        }
                        throw new SolrException(SolrException.ErrorCode.getErrorCode((int)httpStatus), reason);
                    }
                    NamedList namedList = rsp;
                    return namedList;
                    finally {
                        if (respBody != null && shouldClose) {
                            try {
                                respBody.close();
                            }
                            catch (Throwable t) {}
                        }
                    }
                }
            };
            if (SolrRequest.METHOD.GET == request.getMethod()) {
                return (NamedList)this.httpTemplate.get(requestUrl, null, (ResponseExtractor)extractor);
            }
            HttpEntity[] entityHolder = new HttpEntity[1];
            RequestCallback callback = new RequestCallback((SolrParams)params, entityHolder, url){
                final /* synthetic */ SolrParams val$params;
                final /* synthetic */ HttpEntity[] val$entityHolder;
                final /* synthetic */ String val$url;
                {
                    this.val$params = solrParams;
                    this.val$entityHolder = httpEntityArray;
                    this.val$url = string;
                }

                public void doWithRequest(HttpUriRequest request) throws IOException {
                    boolean isMultipart = streams != null && streams.size() > 1;
                    LinkedList<BasicNameValuePair> postParams = new LinkedList<BasicNameValuePair>();
                    HttpPost post = (HttpPost)request;
                    if (streams == null || isMultipart) {
                        post.setHeader("Content-Charset", "UTF-8");
                        if (!isMultipart) {
                            post.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                        }
                        LinkedList<FormBodyPart> parts = new LinkedList<FormBodyPart>();
                        Iterator iter = this.val$params.getParameterNamesIterator();
                        while (iter.hasNext()) {
                            String p = (String)iter.next();
                            String[] vals = this.val$params.getParams(p);
                            if (vals == null) continue;
                            for (String v : vals) {
                                if (isMultipart) {
                                    parts.add(new FormBodyPart(p, (ContentBody)new StringBody(v, Charset.forName("UTF-8"))));
                                    continue;
                                }
                                postParams.add(new BasicNameValuePair(p, v));
                            }
                        }
                        if (isMultipart) {
                            for (ContentStream content : streams) {
                                String contentType = content.getContentType();
                                if (contentType == null) {
                                    contentType = "application/octet-stream";
                                }
                                parts.add(new FormBodyPart(content.getName(), (ContentBody)new InputStreamBody(content.getStream(), contentType, content.getName())));
                            }
                        }
                        if (parts.size() > 0) {
                            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.STRICT);
                            for (FormBodyPart p : parts) {
                                entity.addPart(p);
                            }
                            this.val$entityHolder[0] = entity;
                        } else {
                            this.val$entityHolder[0] = new UrlEncodedFormEntity(postParams, "UTF-8");
                        }
                    } else {
                        String pstr = ClientUtils.toQueryString((SolrParams)this.val$params, (boolean)false);
                        try {
                            post.setURI(new URI(this.val$url + pstr));
                        }
                        catch (URISyntaxException e) {
                            // empty catch block
                        }
                        final ContentStream[] contentStream = new ContentStream[1];
                        Iterator i$ = streams.iterator();
                        if (i$.hasNext()) {
                            ContentStream content;
                            contentStream[0] = content = (ContentStream)i$.next();
                        }
                        this.val$entityHolder[0] = contentStream[0] instanceof RequestWriter.LazyContentStream ? new InputStreamEntity(contentStream[0].getStream(), -1L){

                            public Header getContentType() {
                                return new BasicHeader("Content-Type", contentStream[0].getContentType());
                            }

                            public boolean isRepeatable() {
                                return false;
                            }
                        } : new InputStreamEntity(contentStream[0].getStream(), -1L){

                            public Header getContentType() {
                                return new BasicHeader("Content-Type", contentStream[0].getContentType());
                            }

                            public boolean isRepeatable() {
                                return false;
                            }
                        };
                    }
                }
            };
            return (NamedList)this.httpTemplate.post(url, null, callback, (ResponseExtractor)extractor, entityHolder[0]);
        }
        catch (ConnectException e) {
            throw new SolrServerException("Server refused connection at: " + this.getBaseURL(), (Throwable)e);
        }
        catch (SocketTimeoutException e) {
            throw new SolrServerException("Timeout occured while waiting response from server at: " + this.getBaseURL(), (Throwable)e);
        }
        catch (IOException e) {
            throw new SolrServerException("IOException occured when talking to server at: " + this.getBaseURL(), (Throwable)e);
        }
    }

    public void shutdown() {
        if (this.httpTemplate != null) {
            this.httpTemplate.shutdown();
        }
        super.shutdown();
    }

    public void setSoTimeout(int timeout) {
        if (this.httpTemplate != null) {
            this.httpTemplate.setReadTimeout(timeout);
        }
        super.setSoTimeout(timeout);
    }
}

