/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.taglib;

import cn.pconline.search.common.taglib.HtmlText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class HtmlTag {
    private Map<String, String> attrs;
    private List<HtmlTag> childs;
    private String tagName;

    public HtmlTag() {
    }

    public HtmlTag(String tagName) {
        this.tagName = tagName;
    }

    public HtmlTag(String tagName, HtmlText body) {
        this.tagName = tagName;
        this.addChild(body);
    }

    public void addAttribute(String key, String value) {
        if (this.attrs == null) {
            this.attrs = new HashMap<String, String>();
        }
        this.attrs.put(key, value);
    }

    public void addChild(HtmlTag tag) {
        if (this.childs == null) {
            this.childs = new ArrayList<HtmlTag>();
        }
        this.childs.add(tag);
    }

    public Map<String, String> getAttrs() {
        return this.attrs;
    }

    public void setAttrs(Map<String, String> attrs) {
        this.attrs = attrs;
    }

    public List<HtmlTag> getChilds() {
        return this.childs;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<").append(this.tagName);
        if (MapUtils.isNotEmpty(this.attrs)) {
            for (Map.Entry<String, String> en : this.attrs.entrySet()) {
                builder.append(" ");
                builder.append(en.getKey());
                builder.append("=\"");
                builder.append(en.getValue());
                builder.append("\" ");
            }
        }
        if (CollectionUtils.isEmpty(this.childs)) {
            builder.append("/>");
        } else {
            builder.append(">");
            for (HtmlTag tag : this.childs) {
                builder.append(tag);
            }
            builder.append("</").append(this.tagName).append(">");
        }
        return builder.toString();
    }
}

