package cn.pconline.search.common.taglib;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

import org.apache.commons.lang.StringUtils;

/**
 * 广告合并标签
 * 
 * @author zengjie
 * @since 2013-9-18
 * @see
 */
public class CombineADTag extends BodyTagSupport
{

    Pattern adPattern = Pattern
            .compile("(?i)(<script[^>]*\\ssrc=[\"']?http://www.pc\\w*.com.cn/js/ivy[.]js[^>]*>[^>]*</script>|<script>if[(]!window._addIvyID[)]\\s*document.write[(]['\"]<script[^>]*\\ssrc=['\"]?http://www.pc\\w*.com.cn/js/ivy.js['\"]?><\\\\/script>['\"][)];?</script>)"
                    + "|<script[^>]*\\ssrc=[\"']?(http://ivy.pconline.com.cn/adpuba/show[?]id=([\\w.-]+)([^\"'> ]*?&pid=([\\w.]+))?[^\"'> ]+)[^<]*</script>");

    private static final long serialVersionUID = 6342069424016970875L;

    private String var;

    private String skip;

    private String insertBefore;

    @Override
    public int doEndTag() throws JspException
    {
        String html = getHtml();
        if (html == null)
        {
            return super.doEndTag();
        }

        if (StringUtils.isEmpty(html))
        {
            return super.doEndTag();
        }

        Matcher matcher = adPattern.matcher(html);
        Pattern skipPattern = skip != null && skip.trim().length() > 0 ? java.util.regex.Pattern
                .compile(skip) : null;
        StringBuffer sb = new StringBuffer(html.length()), idstr = new StringBuffer();
        int delayedADs = 0;
        boolean insertBeforeFound = false;
        while (matcher.find())
        {
            if (matcher.group(1) != null)
            {
                matcher.appendReplacement(sb, "");
                continue;
            } // 去掉重复的ivy.js
            String id = matcher.group(3), pid = matcher.group(5);
            if (id.indexOf(".test15.") > 0)
            {
                matcher.appendReplacement(
                        sb,
                        "<script>setTimeout(function(){var js=document.createElement(\"script\"); js.src=\"$2\";document.getElementsByTagName(\"head\")[0].appendChild(js);},999)</script>");
                continue;
            }
            if (skipPattern != null && skipPattern.matcher(id).find()) continue;
            idstr.append(id);
            if (pid != null) idstr.append('|').append(pid);
            idstr.append(';');
            int pos = sb.length();
            matcher.appendReplacement(sb, "<script>showIvyViaJs(\"" + id
                    + "\")</script>");
            if (!insertBeforeFound && insertBefore != null
                    && insertBefore.trim().length() > 0)
            {
                delayedADs++;
                insertBeforeFound = sb.indexOf(insertBefore, pos) >= 0;
            }
        }

        if (idstr.length() < 1)
        {
            try
            {
                getBodyContent().getEnclosingWriter().print(html);
            }
            catch (IOException e)
            {
                throw new JspException(e);
            }

            return EVAL_PAGE;
        }
        // 无广告或已经手工合并，直接输出原内容
        idstr.deleteCharAt(idstr.length() - 1); // 去掉最后一个;号，防止show4接口出错
        matcher.appendTail(sb);

        matcher = java.util.regex.Pattern.compile("(?si)<body[^>]*>").matcher(
                sb);
        int insertPos = -1, body = matcher.find() ? matcher.end() : 0;
        if (insertBefore != null && insertBefore.trim().length() > 0) insertPos = sb
                .indexOf(insertBefore);

        if (insertPos < 0) insertPos = body;
        else if (sb.indexOf("<script>showIvyViaJS") < insertPos)
        {
            // 插入点之前有广告，需要进行广告后出处理
            String s = "<script>_addIvyID=1; function showIvyViaJs(pos){document.write(\"<u id=\"+pos+\" class=adpos></u>\")}</script>\n";
            sb.insert(body, s);
            insertPos += s.length();
            s = "\n<script>_addIvyID=0</script>\n";
            sb.insert(insertPos, s);
            insertPos += s.length();
            // System.out.println("body="+body+",insertPos="+insertPos);
            // 下面的ivyLoadReal处理目的是为了修正IE下write出的script执行顺序
            for (int i = 0; i < delayedADs; i++)
                sb.insert(
                        insertPos,
                        "<script>ivyLoadReal()</script><script class=closespan>ivyLoadReal(true)</script>\n");
            sb.insert(
                    insertPos,
                    "<script>\nfunction ivyLoadReal(closespan){\n    var ad=null, adpos = document.getElementsByTagName(\"u\");\n    for(var i=0; i<adpos.length; i++) if(adpos[i].className==\"adpos\"){ ad=adpos[i]; break; }\n    if(ad==null) return;\n\n    if(!closespan) {\n        document.write(\"<span id=adpos_\"+ad.id+\" style=display:none>\");\n        showIvyViaJs(ad.id);\n        return;\n    }\n\n    document.write(\"</span>\");\n    var real=document.getElementById(\"adpos_\"+ad.id);\n    for(var i=0; i<real.childNodes.length; i++) {\n        var node = real.childNodes[i];\n        if(node.tagName==\"SCRIPT\" && /closespan/.test(node.className)) continue;\n        ad.parentNode.insertBefore(node,ad); i--\n    }\n    ad.parentNode.removeChild(ad);\n    real.parentNode.removeChild(real);\n}\n</script>\n");
        }

        sb.insert(
                insertPos,
                "<script class=combineAD>if(!window._addIvyID)document.write('<script src=http://www.pconline.com.cn/js/ivy.js><\\/script>');"
                        + "\ndocument.write('<script src=\"http://ivy.pconline.com.cn/adpuba/show4?id="
                        + idstr
                        + "\" class=\" defer\"><\\/script>');\n</script class=combineAD>\n\n");
        // sb.insert(insertPos, "<hr>FOUND!<hr>"); //调试时使用
        try
        {
            getBodyContent().getEnclosingWriter().println(sb);
        }
        catch (IOException e)
        {
            throw new JspException(e);
        }

        return super.doEndTag();
    }

    private String getHtml()
    {
        String html = null;
        if (StringUtils.isNotEmpty(var))
        {
            Object v = pageContext.getAttribute(var);
            if (v == null)
            {
                v = pageContext.getRequest().getAttribute(var);
            }
            if (v == null)
            {
                v = pageContext.getSession().getAttribute(var);
            }
            if (v == null)
            {
                v = pageContext.getServletContext().getAttribute(var);
            }
            html = (v == null ? null : v.toString());
        }
        else if (getBodyContent() != null)
        {
            html = getBodyContent().getString();
        }
        if (html == null)
        {
            return null;
        }
        return html.trim();
    }

    public void setSkip(String skip)
    {
        this.skip = skip;
    }

    public void setInsertBefore(String insertBefore)
    {
        this.insertBefore = insertBefore;
    }

    public void setVar(String var)
    {
        this.var = var;
    }

}
