package cn.pconline.search.common.taglib;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

/**
 * 页面常用函数
 * 
 * @author zengjie
 * @since 2013-11-26
 * @see
 */
public class Functions
{

    public static final int HIGHEST_SPECIAL = '>';

    public static char[][] specialCharactersRepresentation = new char[HIGHEST_SPECIAL + 1][];
    static
    {
        specialCharactersRepresentation['&'] = "&amp;".toCharArray();
        specialCharactersRepresentation['<'] = "&lt;".toCharArray();
        specialCharactersRepresentation['>'] = "&gt;".toCharArray();
        specialCharactersRepresentation['"'] = "&#034;".toCharArray();
        specialCharactersRepresentation['\''] = "&#039;".toCharArray();
    }

    /**
     * 对html中的特殊符号进行转义
     * 
     * @param input
     * @return
     * @throws IOException
     */
    public static String escape(String input) throws IOException
    {
        if (input == null)
        {
            return null;
        }
        StringWriter w = new StringWriter();
        out(w, true, input);
        return w.toString();
    }

    /**
     * 对需要用在js中的字符串进行转义
     * 
     * @param input
     * @return
     */
    public static String escapeJs(String input)
    {
        if (input == null)
        {
            return null;
        }
        input = input.replace("\\", "\\\\");
        input = input.replace("\"", "\\\"");
        input = input.replace("'", "\\'");
        return input;
    }

    public static void out(Writer w, boolean escapeXml, Object obj)
            throws IOException
    {
        if (!escapeXml)
        {
            // write chars as is
            if (obj instanceof Reader)
            {
                Reader reader = (Reader) obj;
                char[] buf = new char[4096];
                int count;
                while ((count = reader.read(buf, 0, 4096)) != -1)
                {
                    w.write(buf, 0, count);
                }
            }
            else
            {
                w.write(obj.toString());
            }
        }
        else
        {
            // escape XML chars
            if (obj instanceof Reader)
            {
                Reader reader = (Reader) obj;
                char[] buf = new char[4096];
                int count;
                while ((count = reader.read(buf, 0, 4096)) != -1)
                {
                    writeEscapedXml(buf, count, w);
                }
            }
            else
            {
                String text = obj.toString();
                writeEscapedXml(text.toCharArray(), text.length(), w);
            }
        }
    }

    /**
     * 
     * Optimized to create no extra objects and write directly to the JspWriter
     * using blocks of escaped and unescaped characters
     * 
     */
    private static void writeEscapedXml(char[] buffer, int length, Writer w)
            throws IOException
    {
        int start = 0;

        for (int i = 0; i < length; i++)
        {
            char c = buffer[i];
            if (c <= HIGHEST_SPECIAL)
            {
                char[] escaped = specialCharactersRepresentation[c];
                if (escaped != null)
                {
                    // add unescaped portion
                    if (start < i)
                    {
                        w.write(buffer, start, i - start);
                    }
                    // add escaped xml
                    w.write(escaped);
                    start = i + 1;
                }
            }
        }
        // add rest of unescaped portion
        if (start < length)
        {
            w.write(buffer, start, length - start);
        }
    }
}
