/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.tools.segment.bean;

import cn.pconline.search.common.tools.segment.bean.MidResult;
import cn.pconline.search.common.tools.segment.bean.SegNode;
import java.util.ArrayList;

public class SegResult {
    private long spendTime;
    private String rawContent;
    private ArrayList<MidResult> mrList;

    public SegResult(String rawContent) {
        this.rawContent = rawContent;
    }

    public ArrayList<SegNode> getSegNodeList() {
        ArrayList<SegNode> list = new ArrayList<SegNode>();
        int index = 0;
        if (this.mrList != null) {
            for (MidResult mr : this.mrList) {
                ArrayList<SegNode> finalSegPath = mr.getFinalSegPath();
                if (finalSegPath == null) continue;
                for (SegNode node : finalSegPath) {
                    if (node.getPos() == 1 || node.getPos() == 4) continue;
                    int length = node.getRow() - node.getCol();
                    SegNode newNode = node.clone();
                    newNode.setRow(index);
                    newNode.setCol(index + length);
                    index += length;
                    list.add(newNode);
                }
            }
        }
        return list;
    }

    public String getFinalResult() {
        StringBuffer result = new StringBuffer();
        if (this.mrList != null) {
            for (MidResult mr : this.mrList) {
                ArrayList<SegNode> finalSegPath = mr.getFinalSegPath();
                if (finalSegPath != null) {
                    if (result.length() != 0) {
                        result.append(" ");
                    }
                    result.append(MidResult.outputResult(finalSegPath));
                    continue;
                }
                result.append(mr.getSource());
            }
        }
        return result.toString();
    }

    public ArrayList<MidResult> getMrList() {
        return this.mrList;
    }

    public void setMrList(ArrayList<MidResult> mrList) {
        this.mrList = mrList;
    }

    public String getRawContent() {
        return this.rawContent;
    }

    public void setRawContent(String rawContent) {
        this.rawContent = rawContent;
    }

    public long getSpendTime() {
        return this.spendTime;
    }

    public void addMidResult(MidResult mr) {
        if (this.mrList == null) {
            this.mrList = new ArrayList();
        }
        if (mr != null) {
            this.mrList.add(mr);
        }
    }

    public String toHTML() {
        StringBuffer html = new StringBuffer();
        if (this.rawContent != null) {
            String finalResult;
            html.append("\u539f\u6587\u5185\u5bb9\uff1a");
            html.append("<table border=\"1\" width=\"100%\"><tr><td width=\"100%\">");
            html.append(this.rawContent);
            html.append("</td></tr></table>");
            if (this.mrList != null) {
                for (MidResult mr : this.mrList) {
                    html.append(mr.toHTML());
                }
            }
            if ((finalResult = this.getFinalResult()) != null && finalResult.trim().length() > 0) {
                html.append("<p>\u6700\u7ec8\u5206\u8bcd\u7ed3\u679c\uff1a");
                html.append("<table border=\"1\" width=\"100%\"><tr><td width=\"100%\">");
                html.append("<font color=\"blue\" size=6><b>" + finalResult + "</b></font>");
                html.append("</td></tr></table>");
            }
        }
        return html.toString();
    }

    public void setSpendTime(long spendTime) {
        this.spendTime = spendTime;
    }
}

