package cn.pconline.search.common.query.elements;

/**
 * 查询条件节点
 * 
 * @author zengjie
 * @since 2013-11-29
 * @see Tree
 * @see FieldQuery#newMatchFieldQ(String)
 * @see Pharse
 * @see TextQuery
 * @see Range
 */
public abstract class Element
{

    private float boost = 1F;

    public Element()
    {
    }

    public Element(float boost)
    {
        super();
        this.boost = boost;
    }

    /**
     * 查询权重，默认为1
     * 
     * @param boost
     */
    @SuppressWarnings("unchecked")
    public <Q extends Element> Q setBoost(float boost)
    {
        this.boost = boost;
        return (Q) this;
    }

    /**
     * 查询权重，默认为1
     * 
     * @param boost
     */
    public float getBoost()
    {
        return boost;
    }

    public abstract String toString();

    protected String getBoostString()
    {
        if (boost != 1F)
        {
            return formatFloat(boost);
        }
        return null;
    }

    private static String formatFloat(float f)
    {
        String s = String.valueOf(f);
        int i = 0;
        if ((i = s.indexOf('E')) > 0)
        {
            StringBuilder sb = new StringBuilder();
            boolean negative = s.charAt(i + 1) == '-';
            int eCount = Integer
                    .parseInt(s.substring(negative ? i + 2 : i + 1));
            String base = s.substring(0, i);
            if (negative)
            {
                sb.append("0.");
                int count = 0;
                int last = eCount;
                if (base.indexOf('.') >= 0)
                {
                    count = eCount - base.indexOf('.');
                    last = Integer
                            .parseInt(base.substring(base.indexOf('.') + 1));
                    base = base.substring(0, base.indexOf('.'));
                }
                for (int j = 0; j < count; j++)
                {
                    sb.append("0");
                }
                sb.append(base);
                if (last > 0)
                {
                    sb.append(last);
                }
            }
            else
            {
                int count = eCount;
                if (base.indexOf('.') >= 0)
                {
                    count = eCount - (base.length() - base.indexOf('.') - 1);
                    sb.append(base.substring(0, base.indexOf('.')));
                    sb.append(base.substring(base.indexOf('.') + 1));
                }
                for (int j = 0; j < count; j++)
                {
                    sb.append("0");
                }
                sb.append(".0");
            }
            return sb.toString();
        }
        else
        {
            return s;
        }
    }

}
