package cn.pconline.search.common.query.elements;

/**
 * 字段条件过滤查询
 * 
 * @author zengjie
 * @since 2013-11-29
 * @see
 */
public abstract class FieldQuery extends Element
{

    private String key;

    public FieldQuery(String key)
    {
        super();
        this.key = key;
    }

    public FieldQuery(String key, float boost)
    {
        super(boost);
        this.key = key;
    }

    public String getKey()
    {
        return key;
    }

    public void setKey(String key)
    {
        this.key = key;
    }

    /**
     * 获取查询值表达式
     * 
     * @return
     */
    protected abstract String getValueExpr();

    @Override
    public String toString()
    {
        StringBuilder builder = new StringBuilder();
        builder.append(key).append(":");
        builder.append(getValueExpr());
        if (getBoost() != 1f)
        {
            builder.append("^").append(getBoostString());
        }
        return builder.toString();
    }

    /**
     * 获取一个匹配字段所有值的查询
     * 
     * @param key
     *            如果需要匹配所有文档，key使用"*"
     * @return
     */
    public static FieldQuery newMatchFieldQ(String key)
    {
        return new FieldQuery(key)
        {

            protected String getValueExpr()
            {
                return "*";
            }
        };
    }

}
