package cn.pconline.search.common.query.elements;

import cn.pconline.search.common.util.QueryUtil;

/**
 * 值范围查询
 * 
 * @author zengjie
 * @since 2013-11-29
 * @see
 */
public class Range extends FieldQuery
{

    private Object low;

    private Object up;

    private boolean includeLow;

    private boolean includeUp;

    public Range(String key, Object low, Object up, boolean includeLow,
            boolean includeUp)
    {
        super(key);
        this.low = low;
        this.up = up;
        this.includeLow = includeLow;
        this.includeUp = includeUp;
    }

    public Range(String key, Object low, Object up)
    {
        this(key, low, up, true, true);
    }

    @Override
    protected String getValueExpr()
    {
        if (low == null && up == null)
        {
            return "*";
        }
        StringBuilder out = new StringBuilder();
        if (includeLow)
        {
            out.append("[");
        }
        else
        {
            out.append("{");
        }
        if (low == null)
        {
            out.append("*");
        }
        else
        {
            out.append(QueryUtil.escapeQStr(String.valueOf(low)));
        }
        out.append(" TO ");
        if (up == null)
        {
            out.append("*");
        }
        else
        {
            out.append(QueryUtil.escapeQStr(String.valueOf(up)));
        }
        if (includeUp)
        {
            out.append("]");
        }
        else
        {
            out.append("}");
        }
        return out.toString();
    }
}
