package cn.pconline.search.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

import org.apache.log4j.Logger;

/**
 * 邮件发送工具
 * 
 * @author liuziheng
 * @date 2012-8-9
 * @version
 */
public class Mailer
{

    private static Logger logger = Logger.getLogger(Mailer.class);

    public static void sendMail(String title, String msg, String host,
            String from, String tolist, final String user, final String pwd,
            String[] proxyInfo)
    {
        Properties props = new Properties();
        props.put("mail.smtp.host", host);
        // 邮件发送代理
        if (proxyInfo != null)
        {
            props.setProperty("proxySet", "true");
            props.setProperty("ProxyHost", proxyInfo[0]);
            props.setProperty("ProxyPort", proxyInfo[1]);
        }

        List<String> maillist = null;
        if (maillist == null)
        {
            logger.warn("WARN: mail list is NULL !");
            if (tolist == null || tolist.isEmpty()) return;
            String[] tos = tolist.split(",");

            maillist = new ArrayList<String>(3);
            for (String to : tos)
            {
                maillist.add(to);
            }
        }

        Authenticator authenticator = new Authenticator()
        {

            @Override
            protected PasswordAuthentication getPasswordAuthentication()
            {
                return new PasswordAuthentication(user, pwd);
            }
        };

        Session session = Session.getInstance(props, authenticator);
        MimeMessage message = new MimeMessage(session);

        try
        {
            for (String to : maillist)
            {
                message.setFrom(new InternetAddress(from));
                InternetAddress[] address = { new InternetAddress(to) };
                message.setRecipients(Message.RecipientType.TO, address);
                message.setSubject(title);
                message.setSentDate(new Date());
                // message.setText(msg);
                BodyPart mdp = new MimeBodyPart();
                mdp.setContent(msg, "text/html;charset=gb2312");
                Multipart mm = new MimeMultipart();
                mm.addBodyPart(mdp);
                message.setContent(mm);
                message.saveChanges();
                Transport.send(message);
            }
        }
        catch (AddressException e)
        {
            logger.error("", e);
        }
        catch (MessagingException e)
        {
            logger.error("", e);
        }
        catch (Exception e)
        {
            logger.error("", e);
        }
    }
}
