package cn.pconline.search.common.util;

import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

public class PagerUtil
{

    /**
     * 将query中参数param的值替换成newValue
     * 
     * @param query
     * @param newValue
     * @param param
     * @return String
     * @author kelly 2009-6-9
     */
    public static String replace(String newValue, String param, String query)
    {

        if (query != null)
        {
            query = query.replaceAll("&*" + param + "=[^&]*", "&" + param + "="
                    + newValue);
        }
        return query;
    }

    // 使用rquest.getQueryString会产生编码问题,要在request.setCharacterEncoding("gbk")之后使用
    public static String getQueryString(Map map) throws Exception
    {
        Set ks = map.keySet();
        String queryStr = "";
        Iterator itr = ks.iterator();
        while (itr.hasNext())
        {
            String key = (String) itr.next();
            String[] val = (String[]) map.get(key);

            for (int i = 0; val != null && i < val.length; i++)
            {
                queryStr += key + "=" + URLEncoder.encode(val[i], "GBK") + "&";
            }
        }
        return queryStr.replaceAll("&*$", "");
    }

    /**
     * 没有编码
     * 
     * @param map
     * @return
     * @throws Exception
     *             String
     * @author kelly 2009-7-27
     */
    public static String getQueryStringNoEN(Map map) throws Exception
    {
        Set ks = map.keySet();
        String queryStr = "";
        Iterator itr = ks.iterator();
        while (itr.hasNext())
        {
            String key = (String) itr.next();
            String[] val = (String[]) map.get(key);

            for (int i = 0; val != null && i < val.length; i++)
            {
                queryStr += key + "=" + val[i] + "&";
            }
        }
        return queryStr.replaceAll("&*$", "");
    }

    // 对queryString进行处理,去掉其中指定的参数param
    public static String delQueryStringParam(String queryStr, String param)
    {
        if (queryStr != null)// 保留原先querystring,删除pageNo
        {
            String _queryStr = queryStr
                    .replaceAll("&*" + param + "=[^&]*$", "");
            if (_queryStr.equals(queryStr)) queryStr = queryStr.replaceAll(
                    param + "=[^&]*&*", "");
            else queryStr = _queryStr;
            return queryStr;
        }
        else return "";
    }

    // 对queryString进行处理,去掉其中指定的参数param
    public static String delQueryString(String queryStr, String param)
    {
        if (queryStr != null)// 保留原先querystring,删除pageNo
        {
            String _queryStr = queryStr.replaceAll(param, "");
            return _queryStr;
        }
        else return "";
    }

    /*****************************************************************************
     * 由request获取当前页面url
     * 
     * @param request
     * @return
     */
    public static String getCurrentPage(HttpServletRequest request)
    {
        String currentPage = "http://"
                + request.getServerName()
                + (request.getServerPort() == 80 ? "" : ":"
                        + request.getServerPort()) + request.getRequestURI();
        return currentPage;
    }

    /*****************************************************************************
     * 生成HTML分页字符串,最多显示10页
     * 
     * @param request
     *            : HttpServletRequest
     * @param total
     *            : 结果总数
     * @param pageSize
     *            : 每页显示数
     * @param pageNo
     *            : 页号(1开始)
     * @param pageNoString
     *            : 页号字符串(如pageNo)
     * @param className
     *            : 样式,生成:<div class="className">首页...</div>
     * @return
     * @throws Exception
     */
    public static String getPagerString(HttpServletRequest request, int total,
            int pageSize, int pageNo, String pageNoString, String className)
            throws Exception
    {
        pageNo -= 1;

        int lastCount = (total - 1) / pageSize;
        if (pageNoString == null) pageNoString = "pageNo";
        className = (className == null ? "" : " class=\"" + className + "\"");
        String queryStr = getQueryString(request.getParameterMap());
        String currentPage = "http://"
                + request.getServerName()
                + (request.getServerPort() == 80 ? "" : ":"
                        + request.getServerPort()) + request.getRequestURI();
        String noPageNo = delQueryStringParam(queryStr, pageNoString);
        currentPage += "?" + (noPageNo.equals("") ? "" : noPageNo + "&");
        String aUrl = currentPage;
        String pagerString = "<div" + className + ">共" + (lastCount + 1)
                + "页&nbsp;";

        if (pageNo > 0)
        {
            pagerString += " [<A HREF=\"" + aUrl + "\">首页</A>]";
            pagerString += "<A HREF=\"" + aUrl + pageNoString + "=" + pageNo
                    + "\">上一页</A>";
        }
        for (int i = 0, startPage = ((lastCount - pageNo) < 4) ? (lastCount - 9 > 0 ? (lastCount - 9)
                : 0)
                : ((pageNo - 5) > 0 ? (pageNo - 5) : 0); i < 10; i++)
        {
            if (pageNo == i + startPage)
            {
                pagerString += " <strong>" + (i + startPage + 1) + "</strong>";
            }
            else if (i + startPage > lastCount)
            {
                break;
            }
            else
            {
                pagerString += " [<A HREF=\"" + aUrl + pageNoString + "="
                        + (i + startPage + 1) + "\">" + (i + startPage + 1)
                        + "</A>]";
            }
        }
        if (pageNo < lastCount)
        {
            pagerString += "<A HREF=\"" + aUrl + pageNoString + "="
                    + (pageNo + 2) + "\">下一页</A>";
            pagerString += "[<A HREF=\"" + aUrl + pageNoString + "="
                    + (lastCount + 1) + "\">尾页</A>]";
        }
        pagerString += "</div>";
        return pagerString;
    }

}
