/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.log;

import cn.pconline.search.common.log.SearchLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroupCounter {
    private Map<SearchLog, Counter> items = new HashMap<SearchLog, Counter>();

    public void add(SearchLog item) {
        Counter counter = this.items.get(item);
        if (counter == null) {
            this.items.put(item, new Counter(1));
        } else {
            ++counter.count;
        }
    }

    public Map<SearchLog, Counter> getItems() {
        return this.items;
    }

    public List<Item> getTop(int top) {
        return GroupCounter.top(this.items, top);
    }

    private static List<Item> top(Map<SearchLog, Counter> counter, int num) {
        ArrayList<Item> result = new ArrayList<Item>();
        result.add(Item.ZERO);
        boolean full = false;
        for (SearchLog key : counter.keySet()) {
            int count;
            Item item = new Item(key, count = counter.get((Object)key).count);
            int index = Collections.binarySearch(result, item);
            if (index == -1 || index == 0) continue;
            if (index < 1) {
                index = -index - 1;
            }
            result.add(index, item);
            if (!full) {
                if (result.size() != num) continue;
                full = true;
                continue;
            }
            result.remove(0);
        }
        if (result.get(0) == Item.ZERO) {
            result.remove(0);
        }
        Collections.reverse(result);
        return result;
    }

    public static class Counter {
        public int count = 0;

        public Counter(int count) {
            this.count = count;
        }
    }

    public static class Item
    implements Comparable<Item> {
        private static final String SEP = ":";
        private SearchLog key;
        private int count;
        public static final Item ZERO = new Item(new SearchLog(null, "zero", 0), -1);

        public Item(SearchLog key, int count) {
            this.key = key;
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public SearchLog getKey() {
            return this.key;
        }

        public void setKey(SearchLog key) {
            this.key = key;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.count).append(SEP).append(this.key);
            String result = buf.toString();
            return result;
        }

        @Override
        public int compareTo(Item o) {
            Item item = o;
            int thisVal = this.count;
            int anotherVal = item.count;
            return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    }
}

