/*
 * Decompiled with CFR 0.152.
 */
package cn.pconline.search.common.log;

import cn.pconline.search.common.Configuration;
import cn.pconline.search.common.log.GroupCounter;
import cn.pconline.search.common.log.LogIO;
import cn.pconline.search.common.log.SearchLog;
import cn.pconline.search.common.log.SearchLogHelper;
import cn.pconline.search.common.util.DailyFixTimeRunThread;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.jdbc.OracleDriver;
import org.apache.log4j.Logger;

public class LogSaveThread
extends DailyFixTimeRunThread {
    private static Logger logger = Logger.getLogger(LogSaveThread.class);
    private static final int WEEK = 1;
    private static final int MONTH = 2;
    private static final int YEAR = 3;
    private static final int WEEK_MONTH = 4;
    private static final int WEEK_YEAR = 5;
    private static final int MONTH_YEAR = 6;
    private static final int WEEK_MONTH_YEAR = 7;
    private LogIO logIO;
    private Configuration config;
    private Map<SearchLog, Integer> keyOccurMap;

    public LogSaveThread(LogIO logIO, Configuration config) {
        super(config.getConfig("searchLogSaveTime"), "SearchLog_Save_Thread");
        this.logIO = logIO;
        this.config = config;
        this.testDb();
    }

    private void testDb() {
        logger.debug((Object)"Testing search log db connection...");
        Connection conn = null;
        try {
            conn = this.getConnection();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while try establish db connection", e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    private Connection getConnection() throws SQLException {
        String adDbUrl = this.config.require("ad.dburl");
        String user = this.config.require("ad.user");
        String passwd = this.config.require("ad.passwd");
        DriverManager.registerDriver((Driver)new OracleDriver());
        return DriverManager.getConnection(adDbUrl, user, passwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        this.keyOccurMap = new HashMap<SearchLog, Integer>();
        long startTime = System.currentTimeMillis();
        Connection con = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            int count = this.getUpdateOrSave(con, Integer.MAX_VALUE, LogSaveThread.getNowTime());
            con.commit();
            long endTime = System.currentTimeMillis();
            logger.info((Object)("\u5173\u952e\u5b57\u5165\u5e93\u5b8c\u6bd5!\u6240\u7528\u65f6\u95f4: " + (endTime - startTime) + ",\u603b\u6570\u636e\u6761\u6570:" + count));
        }
        catch (Exception e) {
            logger.error((Object)"Save search log error", (Throwable)e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getUpdateOrSave(Connection conn, int topNum, int time) throws Exception {
        int totalCount;
        Statement insertPs;
        Statement updatePs;
        PreparedStatement existSql;
        block16: {
            ResultSet rs = null;
            existSql = null;
            updatePs = null;
            insertPs = null;
            totalCount = 0;
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                boolean hasUpdate = false;
                List<GroupCounter.Item> list = SearchLogHelper.getTop(this.logIO, topNum < 0 ? Integer.MAX_VALUE : topNum, this.keyOccurMap);
                int c = list.size();
                for (int i = 0; i < c; ++i) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                    GroupCounter.Item item = list.get(i);
                    int count = item.getCount();
                    Integer res = this.keyOccurMap.get(item.getKey());
                    if (existSql == null) {
                        existSql = conn.prepareStatement("select updatetime,week_num,month_num,yesterday_num,year_num from SEARCHKEYLOG sl where sl.keyword=? and sl.app=?");
                    }
                    existSql.setString(1, item.getKey().getKey());
                    existSql.setString(2, item.getKey().getApp());
                    rs = existSql.executeQuery();
                    if (rs.next()) {
                        hasUpdate = sdf.format(rs.getDate("updatetime")).equals(LogIO.getFileKey(LogIO.getYesterday()));
                        if (updatePs == null) {
                            updatePs = conn.prepareStatement("update KS_SEARCHKEY_LOG sl SET sl.summary=sl.summary+?,sl.week_num=?,sl.month_num=?,sl.yesterday_num=?,sl.last_search_num=?,sl.year_num=?,sl.updatetime=sysdate-1 where sl.keyword=? and sl.app= ?");
                        }
                        updatePs.setInt(1, count);
                        updatePs.setInt(2, time == 1 || time == 5 || time == 4 || time == 7 ? count : rs.getInt("week_num") + count);
                        updatePs.setInt(3, time == 2 || time == 6 || time == 4 || time == 7 ? count : rs.getInt("month_num") + count);
                        updatePs.setInt(4, hasUpdate ? rs.getInt("yesterday_num") + count : count);
                        updatePs.setInt(5, res);
                        updatePs.setInt(6, time == 3 || time == 6 || time == 5 || time == 7 ? count : rs.getInt("year_num") + count);
                        updatePs.setString(7, item.getKey().getKey());
                        updatePs.setString(8, item.getKey().getApp());
                        updatePs.addBatch();
                        hasUpdate = false;
                    } else {
                        if (insertPs == null) {
                            insertPs = conn.prepareStatement("insert into KS_SEARCHKEY_LOG(id, keyword, app, summary, createtime, updatetime, week_num, month_num, yesterday_num, year_num, last_search_num) values(SEQ_SERARCHKEY_ID.nextval,?,?,?,sysdate-1,sysdate-1,?,?,?,?,?)");
                        }
                        insertPs.setString(1, item.getKey().getKey());
                        insertPs.setString(2, item.getKey().getApp());
                        insertPs.setInt(3, count);
                        insertPs.setInt(4, count);
                        insertPs.setInt(5, count);
                        insertPs.setInt(6, count);
                        insertPs.setInt(7, count);
                        insertPs.setInt(8, res);
                        insertPs.addBatch();
                    }
                    ++totalCount;
                    rs.close();
                }
                if (updatePs != null) {
                    updatePs.executeBatch();
                }
                if (insertPs != null) {
                    insertPs.executeBatch();
                }
                if (rs == null) break block16;
            }
            catch (Throwable throwable) {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                LogSaveThread.closeState(updatePs);
                LogSaveThread.closeState(insertPs);
                LogSaveThread.closeState(existSql);
                throw throwable;
            }
            try {
                rs.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        LogSaveThread.closeState(updatePs);
        LogSaveThread.closeState(insertPs);
        LogSaveThread.closeState(existSql);
        return totalCount;
    }

    private static void closeState(Statement s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static int getNowTime() {
        boolean isYear;
        Calendar c = Calendar.getInstance();
        c.set(5, c.get(5) - 1);
        boolean isWeek = c.get(7) - 1 == 1;
        boolean isMonth = c.get(5) == c.getMinimum(5);
        boolean bl = isYear = c.get(6) == 1;
        if (isWeek && isMonth && isYear) {
            return 7;
        }
        if (isWeek && isMonth) {
            return 4;
        }
        if (isWeek && isYear) {
            return 5;
        }
        if (isMonth && isYear) {
            return 6;
        }
        if (isWeek) {
            return 1;
        }
        if (isMonth) {
            return 2;
        }
        if (isYear) {
            return 3;
        }
        return -1;
    }
}

